/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.tooling.dsl;

import io.github.detekt.tooling.api.spec.LoggingSpec;
import io.github.detekt.tooling.dsl.Builder;
import io.github.detekt.tooling.dsl.LoggingModel;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00060\u000bj\u0002`\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lio/github/detekt/tooling/dsl/LoggingSpecBuilder;", "Lio/github/detekt/tooling/dsl/Builder;", "Lio/github/detekt/tooling/api/spec/LoggingSpec;", "()V", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "errorChannel", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "getErrorChannel", "()Ljava/lang/Appendable;", "setErrorChannel", "(Ljava/lang/Appendable;)V", "outputChannel", "getOutputChannel", "setOutputChannel", "build", "detekt-tooling"})
public final class LoggingSpecBuilder
implements Builder<LoggingSpec> {
    private boolean debug;
    @NotNull
    private Appendable outputChannel;
    @NotNull
    private Appendable errorChannel;

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final Appendable getOutputChannel() {
        return this.outputChannel;
    }

    public final void setOutputChannel(@NotNull Appendable appendable) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"<set-?>");
        this.outputChannel = appendable;
    }

    @NotNull
    public final Appendable getErrorChannel() {
        return this.errorChannel;
    }

    public final void setErrorChannel(@NotNull Appendable appendable) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"<set-?>");
        this.errorChannel = appendable;
    }

    @Override
    @NotNull
    public LoggingSpec build() {
        return new LoggingModel(this.debug, this.outputChannel, this.errorChannel);
    }

    public LoggingSpecBuilder() {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"System.out");
        this.outputChannel = printStream;
        PrintStream printStream2 = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"System.err");
        this.errorChannel = printStream2;
    }
}

