/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.Status;
import io.grpc.alts.CallCredentialsInterceptor;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.GoogleDefaultProtocolNegotiator;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import javax.net.ssl.SSLException;

public final class GoogleDefaultChannelBuilder
extends ForwardingChannelBuilder<GoogleDefaultChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private GoogleDefaultProtocolNegotiator negotiatorForTest;

    private GoogleDefaultChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget((String)target);
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate(), (InternalNettyChannelBuilder.ProtocolNegotiatorFactory)new ProtocolNegotiatorFactory());
        CallCredentials credentials = null;
        Status status = Status.OK;
        try {
            credentials = MoreCallCredentials.from((Credentials)GoogleCredentials.getApplicationDefault());
        }
        catch (IOException e) {
            status = Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause((Throwable)e);
        }
        this.delegate().intercept(new ClientInterceptor[]{new CallCredentialsInterceptor(credentials, status)});
    }

    public static final GoogleDefaultChannelBuilder forTarget(String target) {
        return new GoogleDefaultChannelBuilder(target);
    }

    public static GoogleDefaultChannelBuilder forAddress(String name, int port) {
        return GoogleDefaultChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort((String)name, (int)port));
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @VisibleForTesting
    GoogleDefaultProtocolNegotiator getProtocolNegotiatorForTest() {
        return this.negotiatorForTest;
    }

    private final class ProtocolNegotiatorFactory
    implements InternalNettyChannelBuilder.ProtocolNegotiatorFactory {
        private ProtocolNegotiatorFactory() {
        }

        public GoogleDefaultProtocolNegotiator buildProtocolNegotiator() {
            SslContext sslContext;
            final AltsProtocolNegotiator.LazyChannel lazyHandshakerChannel = new AltsProtocolNegotiator.LazyChannel((ObjectPool<Channel>)SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL));
            TsiHandshakerFactory altsHandshakerFactory = new TsiHandshakerFactory(){

                @Override
                public TsiHandshaker newHandshaker(String authority) {
                    AltsClientOptions handshakerOptions = new AltsClientOptions.Builder().setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions()).setTargetName(authority).build();
                    return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub(lazyHandshakerChannel.get()), handshakerOptions);
                }
            };
            try {
                sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException ex) {
                throw new RuntimeException(ex);
            }
            return GoogleDefaultChannelBuilder.this.negotiatorForTest = new GoogleDefaultProtocolNegotiator(altsHandshakerFactory, lazyHandshakerChannel, sslContext);
        }
    }
}

