/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.alts.internal.ProtectedPromise;
import io.grpc.alts.internal.TsiFrameProtector;
import io.grpc.alts.internal.TsiHandshakeHandler;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.PendingWriteQueue;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TsiFrameHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final Logger logger = Logger.getLogger(TsiFrameHandler.class.getName());
    private TsiFrameProtector protector;
    private PendingWriteQueue pendingUnprotectedWrites;
    private State state = State.HANDSHAKE_NOT_FINISHED;
    private boolean closeInitiated = false;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        logger.finest("TsiFrameHandler added");
        super.handlerAdded(ctx);
        assert (this.pendingUnprotectedWrites == null);
        this.pendingUnprotectedWrites = new PendingWriteQueue((ChannelHandlerContext)Preconditions.checkNotNull((Object)ctx));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "TsiFrameHandler user event triggered", new Object[]{event});
        }
        if (event instanceof TsiHandshakeHandler.TsiHandshakeCompletionEvent) {
            TsiHandshakeHandler.TsiHandshakeCompletionEvent tsiEvent = (TsiHandshakeHandler.TsiHandshakeCompletionEvent)event;
            if (tsiEvent.isSuccess()) {
                this.setProtector(tsiEvent.protector());
            } else {
                this.state = State.HANDSHAKE_FAILED;
            }
        }
        super.userEventTriggered(ctx, event);
    }

    @VisibleForTesting
    void setProtector(TsiFrameProtector protector) {
        logger.finest("TsiFrameHandler protector set");
        Preconditions.checkState((this.protector == null ? 1 : 0) != 0);
        this.protector = (TsiFrameProtector)Preconditions.checkNotNull((Object)protector);
        this.state = State.PROTECTED;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Preconditions.checkState((this.state == State.PROTECTED ? 1 : 0) != 0, (String)"Cannot read frames while the TSI handshake is %s", (Object)((Object)this.state));
        this.protector.unprotect(in, out, ctx.alloc());
    }

    public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) throws Exception {
        Preconditions.checkState((this.state == State.PROTECTED ? 1 : 0) != 0, (String)"Cannot write frames while the TSI handshake state is %s", (Object)((Object)this.state));
        ByteBuf msg = (ByteBuf)message;
        if (!msg.isReadable()) {
            ChannelPromise possiblyIgnoredError = promise.setSuccess();
            return;
        }
        this.pendingUnprotectedWrites.add((Object)msg, promise);
    }

    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (!this.pendingUnprotectedWrites.isEmpty()) {
            this.pendingUnprotectedWrites.removeAndFailAll((Throwable)new ChannelException("Pending write on removal of TSI handler"));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.pendingUnprotectedWrites.removeAndFailAll(cause);
        super.exceptionCaught(ctx, cause);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.doClose(ctx);
        ctx.disconnect(promise);
    }

    private void doClose(ChannelHandlerContext ctx) {
        if (this.closeInitiated) {
            return;
        }
        this.closeInitiated = true;
        try {
            if (!this.pendingUnprotectedWrites.isEmpty()) {
                this.flush(ctx);
            }
        }
        catch (GeneralSecurityException e) {
            logger.log(Level.FINE, "Ignoring error on flush before close", e);
        }
        finally {
            this.state = State.CLOSED;
            this.release();
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.doClose(ctx);
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.doClose(ctx);
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) {
        ctx.read();
    }

    public void flush(final ChannelHandlerContext ctx) throws GeneralSecurityException {
        if (this.state == State.CLOSED || this.state == State.HANDSHAKE_FAILED) {
            logger.fine(String.format("FrameHandler is inactive(%s), channel id: %s", new Object[]{this.state, ctx.channel().id().asShortText()}));
            return;
        }
        Preconditions.checkState((this.state == State.PROTECTED ? 1 : 0) != 0, (String)"Cannot write frames while the TSI handshake state is %s", (Object)((Object)this.state));
        final ProtectedPromise aggregatePromise = new ProtectedPromise(ctx.channel(), ctx.executor(), this.pendingUnprotectedWrites.size());
        ArrayList<ByteBuf> bufs = new ArrayList<ByteBuf>(this.pendingUnprotectedWrites.size());
        if (this.pendingUnprotectedWrites.isEmpty()) {
            return;
        }
        while (!this.pendingUnprotectedWrites.isEmpty()) {
            ByteBuf in = (ByteBuf)this.pendingUnprotectedWrites.current();
            bufs.add(in.retain());
            aggregatePromise.addUnprotectedPromise(this.pendingUnprotectedWrites.remove());
        }
        this.protector.protectFlush(bufs, new TsiFrameProtector.Consumer<ByteBuf>(){

            @Override
            public void accept(ByteBuf b) {
                ctx.writeAndFlush((Object)b, aggregatePromise.newPromise());
            }
        }, ctx.alloc());
        ChannelPromise possiblyIgnoredError = aggregatePromise.doneAllocatingPromises();
    }

    private void release() {
        if (this.protector != null) {
            this.protector.destroy();
            this.protector = null;
        }
    }

    @VisibleForTesting
    static enum State {
        HANDSHAKE_NOT_FINISHED,
        PROTECTED,
        CLOSED,
        HANDSHAKE_FAILED;

    }
}

