/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.ChannelCredentials;
import io.grpc.ExperimentalApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7479")
public final class ChoiceChannelCredentials
extends ChannelCredentials {
    private final List<ChannelCredentials> creds;

    public static ChannelCredentials create(ChannelCredentials ... creds) {
        if (creds.length == 0) {
            throw new IllegalArgumentException("At least one credential is required");
        }
        return new ChoiceChannelCredentials(creds);
    }

    private ChoiceChannelCredentials(ChannelCredentials ... creds) {
        for (ChannelCredentials cred : creds) {
            if (cred != null) continue;
            throw new NullPointerException();
        }
        this.creds = Collections.unmodifiableList(new ArrayList<ChannelCredentials>(Arrays.asList(creds)));
    }

    public List<ChannelCredentials> getCredentialsList() {
        return this.creds;
    }
}

