/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.census;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.census.internal.ObservabilityCensusConstants;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.propagation.BinaryFormat;
import io.opencensus.trace.unsafe.ContextUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CensusTracingModule {
    private static final Logger logger;
    @Nullable
    private static final AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> callEndedUpdater;
    @Nullable
    private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater;
    private final Tracer censusTracer;
    @VisibleForTesting
    final Metadata.Key<SpanContext> tracingHeader;
    private final TracingClientInterceptor clientInterceptor = new TracingClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();

    CensusTracingModule(Tracer censusTracer, final BinaryFormat censusPropagationBinaryFormat) {
        this.censusTracer = (Tracer)Preconditions.checkNotNull((Object)censusTracer, (Object)"censusTracer");
        Preconditions.checkNotNull((Object)censusPropagationBinaryFormat, (Object)"censusPropagationBinaryFormat");
        this.tracingHeader = Metadata.Key.of((String)"grpc-trace-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<SpanContext>(){

            public byte[] toBytes(SpanContext context) {
                return censusPropagationBinaryFormat.toByteArray(context);
            }

            public SpanContext parseBytes(byte[] serialized) {
                try {
                    return censusPropagationBinaryFormat.fromByteArray(serialized);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed to parse tracing header", e);
                    return SpanContext.INVALID;
                }
            }
        });
    }

    @VisibleForTesting
    CallAttemptsTracerFactory newClientCallTracer(@Nullable Span clientSpan, MethodDescriptor<?, ?> method) {
        return new CallAttemptsTracerFactory(clientSpan, method);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    @VisibleForTesting
    static io.opencensus.trace.Status convertStatus(Status grpcStatus) {
        io.opencensus.trace.Status status;
        switch (grpcStatus.getCode()) {
            case OK: {
                status = io.opencensus.trace.Status.OK;
                break;
            }
            case CANCELLED: {
                status = io.opencensus.trace.Status.CANCELLED;
                break;
            }
            case UNKNOWN: {
                status = io.opencensus.trace.Status.UNKNOWN;
                break;
            }
            case INVALID_ARGUMENT: {
                status = io.opencensus.trace.Status.INVALID_ARGUMENT;
                break;
            }
            case DEADLINE_EXCEEDED: {
                status = io.opencensus.trace.Status.DEADLINE_EXCEEDED;
                break;
            }
            case NOT_FOUND: {
                status = io.opencensus.trace.Status.NOT_FOUND;
                break;
            }
            case ALREADY_EXISTS: {
                status = io.opencensus.trace.Status.ALREADY_EXISTS;
                break;
            }
            case PERMISSION_DENIED: {
                status = io.opencensus.trace.Status.PERMISSION_DENIED;
                break;
            }
            case RESOURCE_EXHAUSTED: {
                status = io.opencensus.trace.Status.RESOURCE_EXHAUSTED;
                break;
            }
            case FAILED_PRECONDITION: {
                status = io.opencensus.trace.Status.FAILED_PRECONDITION;
                break;
            }
            case ABORTED: {
                status = io.opencensus.trace.Status.ABORTED;
                break;
            }
            case OUT_OF_RANGE: {
                status = io.opencensus.trace.Status.OUT_OF_RANGE;
                break;
            }
            case UNIMPLEMENTED: {
                status = io.opencensus.trace.Status.UNIMPLEMENTED;
                break;
            }
            case INTERNAL: {
                status = io.opencensus.trace.Status.INTERNAL;
                break;
            }
            case UNAVAILABLE: {
                status = io.opencensus.trace.Status.UNAVAILABLE;
                break;
            }
            case DATA_LOSS: {
                status = io.opencensus.trace.Status.DATA_LOSS;
                break;
            }
            case UNAUTHENTICATED: {
                status = io.opencensus.trace.Status.UNAUTHENTICATED;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled status code " + grpcStatus.getCode()));
            }
        }
        if (grpcStatus.getDescription() != null) {
            status = status.withDescription(grpcStatus.getDescription());
        }
        return status;
    }

    private static EndSpanOptions createEndSpanOptions(Status status, boolean sampledToLocalTracing) {
        return EndSpanOptions.builder().setStatus(CensusTracingModule.convertStatus(status)).setSampleToLocalSpanStore(sampledToLocalTracing).build();
    }

    private void recordMessageEvent(Span span, MessageEvent.Type type, int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        MessageEvent.Builder eventBuilder = MessageEvent.builder((MessageEvent.Type)type, (long)seqNo);
        if (optionalUncompressedSize != -1L) {
            eventBuilder.setUncompressedMessageSize(optionalUncompressedSize);
        }
        if (optionalWireSize != -1L) {
            eventBuilder.setCompressedMessageSize(optionalWireSize);
        }
        span.addMessageEvent(eventBuilder.build());
    }

    private void recordAnnotation(Span span, MessageEvent.Type type, int seqNo, boolean isCompressed, long size) {
        String messageType = isCompressed ? "compressed" : "uncompressed";
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        attributes.put("id", AttributeValue.longAttributeValue((long)seqNo));
        attributes.put("type", AttributeValue.stringAttributeValue((String)messageType));
        String messageDirection = type == MessageEvent.Type.SENT ? "\u2197 " : "\u2198 ";
        String inlineDescription = messageDirection + size + " bytes " + type.name().toLowerCase(Locale.US);
        span.addAnnotation(inlineDescription, attributes);
    }

    @VisibleForTesting
    static String generateTraceSpanName(boolean isServer, String fullMethodName) {
        String prefix = isServer ? "Recv" : "Sent";
        return prefix + "." + fullMethodName.replace('/', '.');
    }

    static {
        AtomicIntegerFieldUpdater<ServerTracer> tmpStreamClosedUpdater;
        AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> tmpCallEndedUpdater;
        logger = Logger.getLogger(CensusTracingModule.class.getName());
        try {
            tmpCallEndedUpdater = AtomicIntegerFieldUpdater.newUpdater(CallAttemptsTracerFactory.class, "callEnded");
            tmpStreamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
            tmpCallEndedUpdater = null;
            tmpStreamClosedUpdater = null;
        }
        callEndedUpdater = tmpCallEndedUpdater;
        streamClosedUpdater = tmpStreamClosedUpdater;
    }

    @VisibleForTesting
    final class TracingClientInterceptor
    implements ClientInterceptor {
        TracingClientInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            Span parentSpan = ContextUtils.getValue((Context)Context.current());
            Span clientSpan = CensusTracingModule.this.censusTracer.spanBuilderWithExplicitParent(CensusTracingModule.generateTraceSpanName(false, method.getFullMethodName()), parentSpan).setRecordEvents(true).startSpan();
            final CallAttemptsTracerFactory tracerFactory = CensusTracingModule.this.newClientCallTracer(clientSpan, method);
            ClientCall call = next.newCall(method, callOptions.withStreamTracerFactory((ClientStreamTracer.Factory)tracerFactory).withOption(ObservabilityCensusConstants.CLIENT_TRACE_SPAN_CONTEXT_KEY, (Object)clientSpan.getContext()));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            SpanContext remoteSpan = (SpanContext)headers.get(CensusTracingModule.this.tracingHeader);
            if (remoteSpan == SpanContext.INVALID) {
                remoteSpan = null;
            }
            return new ServerTracer(fullMethodName, remoteSpan);
        }
    }

    private final class ServerTracer
    extends ServerStreamTracer {
        private final Span span;
        volatile boolean isSampledToLocalTracing;
        volatile int streamClosed;
        private int seqNo;

        ServerTracer(@Nullable String fullMethodName, SpanContext remoteSpan) {
            Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.span = CensusTracingModule.this.censusTracer.spanBuilderWithRemoteParent(CensusTracingModule.generateTraceSpanName(true, fullMethodName), remoteSpan).setRecordEvents(true).startSpan();
        }

        public void serverCallStarted(ServerStreamTracer.ServerCallInfo<?, ?> callInfo) {
            this.isSampledToLocalTracing = callInfo.getMethodDescriptor().isSampledToLocalTracing();
        }

        public void streamClosed(Status status) {
            if (streamClosedUpdater != null) {
                if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.streamClosed != 0) {
                    return;
                }
                this.streamClosed = 1;
            }
            this.span.end(CensusTracingModule.createEndSpanOptions(status, this.isSampledToLocalTracing));
        }

        public Context filterContext(Context context) {
            return ContextUtils.withValue((Context)context, (Span)this.span);
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordMessageEvent(this.span, MessageEvent.Type.SENT, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordAnnotation(this.span, MessageEvent.Type.RECEIVED, seqNo, true, optionalWireSize);
        }

        public void inboundMessage(int seqNo) {
            this.seqNo = seqNo;
        }

        public void inboundUncompressedSize(long bytes) {
            CensusTracingModule.this.recordAnnotation(this.span, MessageEvent.Type.RECEIVED, this.seqNo, false, bytes);
        }
    }

    private final class ClientTracer
    extends ClientStreamTracer {
        private final Span span;
        private final Span parentSpan;
        final Metadata.Key<SpanContext> tracingHeader;
        final boolean isSampledToLocalTracing;
        volatile int seqNo;
        boolean isPendingStream;

        ClientTracer(Span span, Span parentSpan, Metadata.Key<SpanContext> tracingHeader, boolean isSampledToLocalTracing) {
            this.span = (Span)Preconditions.checkNotNull((Object)span, (Object)"span");
            this.parentSpan = (Span)Preconditions.checkNotNull((Object)parentSpan, (Object)"parent span");
            this.tracingHeader = tracingHeader;
            this.isSampledToLocalTracing = isSampledToLocalTracing;
        }

        public void streamCreated(Attributes transportAtts, Metadata headers) {
            if (this.span != BlankSpan.INSTANCE) {
                headers.discardAll(this.tracingHeader);
                headers.put(this.tracingHeader, (Object)this.span.getContext());
            }
            if (this.isPendingStream) {
                this.span.addAnnotation("Delayed LB pick complete");
            }
        }

        public void createPendingStream() {
            this.isPendingStream = true;
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordMessageEvent(this.span, MessageEvent.Type.SENT, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordAnnotation(this.span, MessageEvent.Type.RECEIVED, seqNo, true, optionalWireSize);
        }

        public void inboundMessage(int seqNo) {
            this.seqNo = seqNo;
        }

        public void inboundUncompressedSize(long bytes) {
            CensusTracingModule.this.recordAnnotation(this.parentSpan, MessageEvent.Type.RECEIVED, this.seqNo, false, bytes);
        }

        public void streamClosed(Status status) {
            this.span.end(CensusTracingModule.createEndSpanOptions(status, this.isSampledToLocalTracing));
        }
    }

    @VisibleForTesting
    final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        volatile int callEnded;
        private final boolean isSampledToLocalTracing;
        private final Span span;
        private final String fullMethodName;

        CallAttemptsTracerFactory(Span clientSpan, MethodDescriptor<?, ?> method) {
            Preconditions.checkNotNull(method, (Object)"method");
            this.isSampledToLocalTracing = method.isSampledToLocalTracing();
            this.fullMethodName = method.getFullMethodName();
            this.span = clientSpan;
        }

        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            Span attemptSpan = CensusTracingModule.this.censusTracer.spanBuilderWithExplicitParent("Attempt." + this.fullMethodName.replace('/', '.'), this.span).setRecordEvents(true).startSpan();
            attemptSpan.putAttribute("previous-rpc-attempts", AttributeValue.longAttributeValue((long)info.getPreviousAttempts()));
            attemptSpan.putAttribute("transparent-retry", AttributeValue.booleanAttributeValue((boolean)info.isTransparentRetry()));
            if (info.getCallOptions().getOption(ClientStreamTracer.NAME_RESOLUTION_DELAYED) != null) {
                this.span.addAnnotation("Delayed name resolution complete");
            }
            return new ClientTracer(attemptSpan, this.span, CensusTracingModule.this.tracingHeader, this.isSampledToLocalTracing);
        }

        void callEnded(Status status) {
            if (callEndedUpdater != null) {
                if (callEndedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.callEnded != 0) {
                    return;
                }
                this.callEnded = 1;
            }
            this.span.end(CensusTracingModule.createEndSpanOptions(status, this.isSampledToLocalTracing));
        }
    }
}

