/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.ServiceConfigUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RoundRobinLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final Attributes.Key<Ref<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create("state-info");
    static final Attributes.Key<Ref<LoadBalancer.Subchannel>> STICKY_REF = Attributes.Key.create("sticky-ref");
    private final LoadBalancer.Helper helper;
    private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
    private final Random random;
    private ConnectivityState currentState;
    private RoundRobinPicker currentPicker = new EmptyPicker(EMPTY_OK);
    @Nullable
    private StickinessState stickinessState;
    private static final Status EMPTY_OK = Status.OK.withDescription("no subchannels ready");

    RoundRobinLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.random = new Random();
    }

    @Override
    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
        Object stickinessMetadataKey;
        Set<EquivalentAddressGroup> currentAddrs = this.subchannels.keySet();
        Set<EquivalentAddressGroup> latestAddrs = RoundRobinLoadBalancer.stripAttrs(servers);
        Set<EquivalentAddressGroup> addedAddrs = RoundRobinLoadBalancer.setsDifference(latestAddrs, currentAddrs);
        Set<EquivalentAddressGroup> removedAddrs = RoundRobinLoadBalancer.setsDifference(currentAddrs, latestAddrs);
        Map<String, Object> serviceConfig = attributes.get(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG);
        if (serviceConfig != null && (stickinessMetadataKey = ServiceConfigUtil.getStickinessMetadataKeyFromServiceConfig(serviceConfig)) != null) {
            if (((String)stickinessMetadataKey).endsWith("-bin")) {
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.WARNING, "Binary stickiness header is not supported. The header \"{0}\" will be ignored", stickinessMetadataKey);
            } else if (this.stickinessState == null || !this.stickinessState.key.name().equals(stickinessMetadataKey)) {
                this.stickinessState = new StickinessState((String)stickinessMetadataKey);
            }
        }
        for (EquivalentAddressGroup addressGroup : addedAddrs) {
            Attributes.Builder subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new Ref<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE)));
            Ref<Object> stickyRef = null;
            if (this.stickinessState != null) {
                stickyRef = new Ref<Object>(null);
                subchannelAttrs.set(STICKY_REF, stickyRef);
            }
            LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)this.helper.createSubchannel(addressGroup, subchannelAttrs.build()), (Object)"subchannel");
            if (stickyRef != null) {
                stickyRef.value = subchannel;
            }
            this.subchannels.put(addressGroup, subchannel);
            subchannel.requestConnection();
        }
        ArrayList<LoadBalancer.Subchannel> removedSubchannels = new ArrayList<LoadBalancer.Subchannel>();
        for (EquivalentAddressGroup addressGroup : removedAddrs) {
            removedSubchannels.add(this.subchannels.remove(addressGroup));
        }
        this.updateBalancingState();
        for (LoadBalancer.Subchannel removedSubchannel : removedSubchannels) {
            this.shutdownSubchannel(removedSubchannel);
        }
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.currentPicker instanceof ReadyPicker ? this.currentPicker : new EmptyPicker(error));
    }

    @Override
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        if (this.subchannels.get(subchannel.getAddresses()) != subchannel) {
            return;
        }
        if (stateInfo.getState() == ConnectivityState.SHUTDOWN && this.stickinessState != null) {
            this.stickinessState.remove(subchannel);
        }
        if (stateInfo.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value = stateInfo;
        this.updateBalancingState();
    }

    private void shutdownSubchannel(LoadBalancer.Subchannel subchannel) {
        subchannel.shutdown();
        RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value = ConnectivityStateInfo.forNonError(ConnectivityState.SHUTDOWN);
        if (this.stickinessState != null) {
            this.stickinessState.remove(subchannel);
        }
    }

    @Override
    public void shutdown() {
        for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
            this.shutdownSubchannel(subchannel);
        }
    }

    private void updateBalancingState() {
        List<LoadBalancer.Subchannel> activeList = RoundRobinLoadBalancer.filterNonFailingSubchannels(this.getSubchannels());
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            Status aggStatus = EMPTY_OK;
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value;
                if (stateInfo.getState() == ConnectivityState.CONNECTING || stateInfo.getState() == ConnectivityState.IDLE) {
                    isConnecting = true;
                }
                if (aggStatus != EMPTY_OK && aggStatus.isOk()) continue;
                aggStatus = stateInfo.getStatus();
            }
            this.updateBalancingState(isConnecting ? ConnectivityState.CONNECTING : ConnectivityState.TRANSIENT_FAILURE, new EmptyPicker(aggStatus));
        } else {
            int startIndex = this.random.nextInt(activeList.size());
            this.updateBalancingState(ConnectivityState.READY, new ReadyPicker(activeList, startIndex, this.stickinessState));
        }
    }

    private void updateBalancingState(ConnectivityState state, RoundRobinPicker picker) {
        if (state != this.currentState || !picker.isEquivalentTo(this.currentPicker)) {
            this.helper.updateBalancingState(state, picker);
            this.currentState = state;
            this.currentPicker = picker;
        }
    }

    private static List<LoadBalancer.Subchannel> filterNonFailingSubchannels(Collection<LoadBalancer.Subchannel> subchannels) {
        ArrayList<LoadBalancer.Subchannel> readySubchannels = new ArrayList<LoadBalancer.Subchannel>(subchannels.size());
        for (LoadBalancer.Subchannel subchannel : subchannels) {
            if (!RoundRobinLoadBalancer.isReady(subchannel)) continue;
            readySubchannels.add(subchannel);
        }
        return readySubchannels;
    }

    private static Set<EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> groupList) {
        HashSet<EquivalentAddressGroup> addrs = new HashSet<EquivalentAddressGroup>(groupList.size());
        for (EquivalentAddressGroup group : groupList) {
            addrs.add(new EquivalentAddressGroup(group.getAddresses()));
        }
        return addrs;
    }

    @VisibleForTesting
    Collection<LoadBalancer.Subchannel> getSubchannels() {
        return this.subchannels.values();
    }

    private static Ref<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer.Subchannel subchannel) {
        return (Ref)Preconditions.checkNotNull(subchannel.getAttributes().get(STATE_INFO), (Object)"STATE_INFO");
    }

    static boolean isReady(LoadBalancer.Subchannel subchannel) {
        return ((ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value).getState() == ConnectivityState.READY;
    }

    private static <T> Set<T> setsDifference(Set<T> a, Set<T> b) {
        HashSet<T> aCopy = new HashSet<T>(a);
        aCopy.removeAll(b);
        return aCopy;
    }

    Map<String, Ref<LoadBalancer.Subchannel>> getStickinessMapForTest() {
        if (this.stickinessState == null) {
            return null;
        }
        return this.stickinessState.stickinessMap;
    }

    @VisibleForTesting
    static final class Ref<T> {
        T value;

        Ref(T value) {
            this.value = value;
        }
    }

    @VisibleForTesting
    static final class EmptyPicker
    extends RoundRobinPicker {
        private final Status status;

        EmptyPicker(@Nonnull Status status) {
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.status.isOk() ? LoadBalancer.PickResult.withNoResult() : LoadBalancer.PickResult.withError(this.status);
        }

        @Override
        boolean isEquivalentTo(RoundRobinPicker picker) {
            return picker instanceof EmptyPicker && (Objects.equal((Object)this.status, (Object)((EmptyPicker)picker).status) || this.status.isOk() && ((EmptyPicker)picker).status.isOk());
        }
    }

    @VisibleForTesting
    static final class ReadyPicker
    extends RoundRobinPicker {
        private static final AtomicIntegerFieldUpdater<ReadyPicker> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(ReadyPicker.class, "index");
        private final List<LoadBalancer.Subchannel> list;
        @Nullable
        private final StickinessState stickinessState;
        private volatile int index;

        ReadyPicker(List<LoadBalancer.Subchannel> list, int startIndex, @Nullable StickinessState stickinessState) {
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"empty list");
            this.list = list;
            this.stickinessState = stickinessState;
            this.index = startIndex - 1;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            String stickinessValue;
            LoadBalancer.Subchannel subchannel = null;
            if (!(this.stickinessState == null || (stickinessValue = args.getHeaders().get(this.stickinessState.key)) == null || (subchannel = this.stickinessState.getSubchannel(stickinessValue)) != null && RoundRobinLoadBalancer.isReady(subchannel))) {
                subchannel = this.stickinessState.maybeRegister(stickinessValue, this.nextSubchannel());
            }
            return LoadBalancer.PickResult.withSubchannel(subchannel != null ? subchannel : this.nextSubchannel());
        }

        private LoadBalancer.Subchannel nextSubchannel() {
            int size = this.list.size();
            int i = indexUpdater.incrementAndGet(this);
            if (i >= size) {
                int oldi = i;
                indexUpdater.compareAndSet(this, oldi, i %= size);
            }
            return this.list.get(i);
        }

        @VisibleForTesting
        List<LoadBalancer.Subchannel> getList() {
            return this.list;
        }

        @Override
        boolean isEquivalentTo(RoundRobinPicker picker) {
            if (!(picker instanceof ReadyPicker)) {
                return false;
            }
            ReadyPicker other = (ReadyPicker)picker;
            return other == this || this.stickinessState == other.stickinessState && this.list.size() == other.list.size() && new HashSet<LoadBalancer.Subchannel>(this.list).containsAll(other.list);
        }
    }

    private static abstract class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        private RoundRobinPicker() {
        }

        abstract boolean isEquivalentTo(RoundRobinPicker var1);
    }

    @VisibleForTesting
    static final class StickinessState {
        static final int MAX_ENTRIES = 1000;
        final Metadata.Key<String> key;
        final ConcurrentMap<String, Ref<LoadBalancer.Subchannel>> stickinessMap = new ConcurrentHashMap<String, Ref<LoadBalancer.Subchannel>>();
        final Queue<String> evictionQueue = new ConcurrentLinkedQueue<String>();

        StickinessState(@Nonnull String stickinessKey) {
            this.key = Metadata.Key.of(stickinessKey, Metadata.ASCII_STRING_MARSHALLER);
        }

        @Nonnull
        LoadBalancer.Subchannel maybeRegister(String stickinessValue, @Nonnull LoadBalancer.Subchannel subchannel) {
            Ref<LoadBalancer.Subchannel> existingSubchannelRef;
            Ref<LoadBalancer.Subchannel> newSubchannelRef = subchannel.getAttributes().get(STICKY_REF);
            do {
                if ((existingSubchannelRef = this.stickinessMap.putIfAbsent(stickinessValue, newSubchannelRef)) == null) {
                    this.addToEvictionQueue(stickinessValue);
                    return subchannel;
                }
                LoadBalancer.Subchannel existingSubchannel = (LoadBalancer.Subchannel)existingSubchannelRef.value;
                if (existingSubchannel == null || !RoundRobinLoadBalancer.isReady(existingSubchannel)) continue;
                return existingSubchannel;
            } while (!this.stickinessMap.replace(stickinessValue, existingSubchannelRef, newSubchannelRef));
            return subchannel;
        }

        private void addToEvictionQueue(String value) {
            String oldValue;
            while (this.stickinessMap.size() >= 1000 && (oldValue = this.evictionQueue.poll()) != null) {
                this.stickinessMap.remove(oldValue);
            }
            this.evictionQueue.add(value);
        }

        void remove(LoadBalancer.Subchannel subchannel) {
            subchannel.getAttributes().get(RoundRobinLoadBalancer.STICKY_REF).value = null;
        }

        @Nullable
        LoadBalancer.Subchannel getSubchannel(String stickinessValue) {
            Ref subchannelRef = (Ref)this.stickinessMap.get(stickinessValue);
            if (subchannelRef != null) {
                return (LoadBalancer.Subchannel)subchannelRef.value;
            }
            return null;
        }
    }
}

