/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.internal.AbstractServerStream;
import io.grpc.internal.AbstractStream2;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.netty.CancelServerStreamCommand;
import io.grpc.netty.NettyReadableBuffer;
import io.grpc.netty.NettyServerHandler;
import io.grpc.netty.NettyWritableBuffer;
import io.grpc.netty.NettyWritableBufferAllocator;
import io.grpc.netty.RequestMessagesCommand;
import io.grpc.netty.SendGrpcFrameCommand;
import io.grpc.netty.SendResponseHeadersCommand;
import io.grpc.netty.StreamIdHolder;
import io.grpc.netty.Utils;
import io.grpc.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;

class NettyServerStream
extends AbstractServerStream {
    private static final Logger log = Logger.getLogger(NettyServerStream.class.getName());
    private final Sink sink = new Sink();
    private final TransportState state;
    private final Channel channel;
    private final WriteQueue writeQueue;
    private final Attributes attributes;

    public NettyServerStream(Channel channel, TransportState state) {
        super((WritableBufferAllocator)new NettyWritableBufferAllocator(channel.alloc()));
        this.state = (TransportState)Preconditions.checkNotNull((Object)state, (Object)"transportState");
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.writeQueue = state.handler.getWriteQueue();
        this.attributes = NettyServerStream.buildAttributes(channel);
    }

    protected TransportState transportState() {
        return this.state;
    }

    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    public Attributes attributes() {
        return this.attributes;
    }

    private static Attributes buildAttributes(Channel channel) {
        SSLSession sslSession = null;
        if (channel.hasAttr(Utils.SSL_SESSION_ATTR_KEY)) {
            sslSession = (SSLSession)channel.attr(Utils.SSL_SESSION_ATTR_KEY).get();
        }
        return Attributes.newBuilder().set(ServerCall.REMOTE_ADDR_KEY, (Object)channel.remoteAddress()).set(ServerCall.SSL_SESSION_KEY, (Object)sslSession).build();
    }

    public void setListener(ServerStreamListener serverStreamListener) {
        this.state.setListener(serverStreamListener);
    }

    public static class TransportState
    extends AbstractServerStream.TransportState
    implements StreamIdHolder {
        private final Http2Stream http2Stream;
        private final NettyServerHandler handler;

        public TransportState(NettyServerHandler handler, Http2Stream http2Stream, int maxMessageSize) {
            super(maxMessageSize);
            this.http2Stream = (Http2Stream)Preconditions.checkNotNull((Object)http2Stream, (Object)"http2Stream");
            this.handler = (NettyServerHandler)((Object)Preconditions.checkNotNull((Object)((Object)handler), (Object)"handler"));
        }

        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        protected void deframeFailed(Throwable cause) {
            log.log(Level.WARNING, "Exception processing message", cause);
            Status status = Status.fromThrowable((Throwable)cause);
            this.transportReportStatus(status);
            this.handler.getWriteQueue().enqueue(new CancelServerStreamCommand(this, status), true);
        }

        void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
            super.inboundDataReceived((ReadableBuffer)new NettyReadableBuffer(frame.retain()), endOfStream);
        }

        @Override
        public Integer id() {
            return this.http2Stream.id();
        }
    }

    private class Sink
    implements AbstractServerStream.Sink {
        private Sink() {
        }

        public void request(int numMessages) {
            if (NettyServerStream.this.channel.eventLoop().inEventLoop()) {
                NettyServerStream.this.transportState().requestMessagesFromDeframer(numMessages);
            } else {
                NettyServerStream.this.writeQueue.enqueue(new RequestMessagesCommand((AbstractStream2.TransportState)NettyServerStream.this.transportState(), numMessages), true);
            }
        }

        public void writeHeaders(Metadata headers) {
            NettyServerStream.this.writeQueue.enqueue(new SendResponseHeadersCommand(NettyServerStream.this.transportState(), Utils.convertServerHeaders(headers), false), true);
        }

        public void writeFrame(WritableBuffer frame, boolean flush) {
            if (frame == null) {
                NettyServerStream.this.writeQueue.scheduleFlush();
                return;
            }
            ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf();
            final int numBytes = bytebuf.readableBytes();
            NettyServerStream.this.onSendingBytes(numBytes);
            NettyServerStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyServerStream.this.transportState(), bytebuf, false), NettyServerStream.this.channel.newPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyServerStream.this.transportState().onSentBytes(numBytes);
                }
            }), flush);
        }

        public void writeTrailers(Metadata trailers, boolean headersSent) {
            Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
            NettyServerStream.this.writeQueue.enqueue(new SendResponseHeadersCommand(NettyServerStream.this.transportState(), http2Trailers, true), true);
        }

        public void cancel(Status status) {
            NettyServerStream.this.writeQueue.enqueue(new CancelServerStreamCommand(NettyServerStream.this.transportState(), status), true);
        }
    }
}

