/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServer;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.ProtocolNegotiators;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@CanIgnoreReturnValue
public final class NettyServerBuilder
extends AbstractServerImplBuilder<NettyServerBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private final SocketAddress address;
    private Class<? extends ServerChannel> channelType = NioServerSocketChannel.class;
    @Nullable
    private EventLoopGroup bossEventLoopGroup;
    @Nullable
    private EventLoopGroup workerEventLoopGroup;
    private SslContext sslContext;
    private ProtocolNegotiator protocolNegotiator;
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    private int flowControlWindow = 0x100000;
    private int maxMessageSize = 0x400000;
    private int maxHeaderListSize = 8192;

    @CheckReturnValue
    public static NettyServerBuilder forPort(int port) {
        return new NettyServerBuilder(port);
    }

    @CheckReturnValue
    public static NettyServerBuilder forAddress(SocketAddress address) {
        return new NettyServerBuilder(address);
    }

    @CheckReturnValue
    private NettyServerBuilder(int port) {
        this.address = new InetSocketAddress(port);
    }

    @CheckReturnValue
    private NettyServerBuilder(SocketAddress address) {
        this.address = address;
    }

    public NettyServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        return this;
    }

    public NettyServerBuilder bossEventLoopGroup(EventLoopGroup group) {
        this.bossEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder workerEventLoopGroup(EventLoopGroup group) {
        this.workerEventLoopGroup = group;
        return this;
    }

    public NettyServerBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument((boolean)sslContext.isServer(), (Object)"Client SSL context can not be used for server");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        this.sslContext = sslContext;
        return this;
    }

    public final NettyServerBuilder protocolNegotiator(@Nullable ProtocolNegotiator protocolNegotiator) {
        this.protocolNegotiator = protocolNegotiator;
        return this;
    }

    public NettyServerBuilder maxConcurrentCallsPerConnection(int maxCalls) {
        Preconditions.checkArgument((maxCalls > 0 ? 1 : 0) != 0, (String)"max must be positive: %s", (Object[])new Object[]{maxCalls});
        this.maxConcurrentCallsPerConnection = maxCalls;
        return this;
    }

    public NettyServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    public NettyServerBuilder maxMessageSize(int maxMessageSize) {
        Preconditions.checkArgument((maxMessageSize >= 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public NettyServerBuilder maxHeaderListSize(int maxHeaderListSize) {
        Preconditions.checkArgument((maxHeaderListSize > 0 ? 1 : 0) != 0, (Object)"maxHeaderListSize must be > 0");
        this.maxHeaderListSize = maxHeaderListSize;
        return this;
    }

    @CheckReturnValue
    protected NettyServer buildTransportServer() {
        ProtocolNegotiator negotiator = this.protocolNegotiator;
        if (negotiator == null) {
            negotiator = this.sslContext != null ? ProtocolNegotiators.serverTls(this.sslContext) : ProtocolNegotiators.serverPlaintext();
        }
        return new NettyServer(this.address, this.channelType, this.bossEventLoopGroup, this.workerEventLoopGroup, negotiator, this.maxConcurrentCallsPerConnection, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize);
    }

    public NettyServerBuilder useTransportSecurity(File certChain, File privateKey) {
        try {
            this.sslContext = GrpcSslContexts.forServer(certChain, privateKey).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }
}

