/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.nano;

import com.google.common.base.Preconditions;
import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.MessageNano;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.nano.MessageNanoFactory;
import io.grpc.protobuf.nano.NanoProtoInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class NanoUtils {
    private NanoUtils() {
    }

    public static <T extends MessageNano> MethodDescriptor.Marshaller<T> marshaller(MessageNanoFactory<T> factory) {
        return new MessageMarshaller<T>(factory);
    }

    private static final class MessageMarshaller<T extends MessageNano>
    implements MethodDescriptor.Marshaller<T> {
        private static final int BUF_SIZE = 8192;
        private final MessageNanoFactory<T> factory;

        MessageMarshaller(MessageNanoFactory<T> factory) {
            this.factory = factory;
        }

        public InputStream stream(T value) {
            return new NanoProtoInputStream((MessageNano)value);
        }

        public T parse(InputStream stream) {
            try {
                CodedInputByteBufferNano input = CodedInputByteBufferNano.newInstance((byte[])MessageMarshaller.toByteArray(stream));
                input.setSizeLimit(Integer.MAX_VALUE);
                T message = this.factory.newInstance();
                message.mergeFrom(input);
                return message;
            }
            catch (IOException ipbe) {
                throw Status.INTERNAL.withDescription("Failed parsing nano proto message").withCause((Throwable)ipbe).asRuntimeException();
            }
        }

        private static byte[] toByteArray(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessageMarshaller.copy(in, out);
            return out.toByteArray();
        }

        private static long copy(InputStream from, OutputStream to) throws IOException {
            int r;
            Preconditions.checkNotNull((Object)from);
            Preconditions.checkNotNull((Object)to);
            byte[] buf = new byte[8192];
            long total = 0L;
            while ((r = from.read(buf)) != -1) {
                to.write(buf, 0, r);
                total += (long)r;
            }
            return total;
        }
    }
}

