/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedInts;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.Struct;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.StatusOr;
import io.grpc.internal.GrpcUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.util.OutlierDetectionLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.CdsLoadBalancerProvider;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClusterResource;
import io.grpc.xds.XdsConfig;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.client.Locality;
import io.grpc.xds.client.XdsLogger;
import io.grpc.xds.internal.XdsInternalAttributes;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class CdsLoadBalancer2
extends LoadBalancer {
    static boolean pickFirstWeightedShuffling = GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_PF_WEIGHTED_SHUFFLING", (boolean)true);
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final LoadBalancerRegistry lbRegistry;
    private final ClusterState clusterState = new ClusterState();
    private GracefulSwitchLoadBalancer delegate;
    private String clusterName;
    private XdsConfig.Subscription clusterSubscription;
    private static final int FIXED_POINT_FRACTIONAL_BITS = 31;

    CdsLoadBalancer2(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.delegate = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cds-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        XdsConfig xdsConfig;
        StatusOr clusterConfigOr;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.clusterName == null) {
            CdsLoadBalancerProvider.CdsConfig config = (CdsLoadBalancerProvider.CdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Config: {0}", config);
            if (config.isDynamic) {
                this.clusterSubscription = ((XdsConfig.XdsClusterSubscriptionRegistry)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLUSTER_SUBSCRIPT_REGISTRY)).subscribeToCluster(config.name);
            }
            this.clusterName = config.name;
        }
        if ((clusterConfigOr = (StatusOr)(xdsConfig = (XdsConfig)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CONFIG)).getClusters().get((Object)this.clusterName)) == null) {
            if (this.clusterSubscription == null) {
                return this.fail(Status.INTERNAL.withDescription(this.errorPrefix() + "Unable to find non-dynamic cluster"));
            }
            return Status.OK;
        }
        if (!clusterConfigOr.hasValue()) {
            return this.fail(clusterConfigOr.getStatus());
        }
        XdsConfig.XdsClusterConfig clusterConfig = (XdsConfig.XdsClusterConfig)clusterConfigOr.getValue();
        if (clusterConfig.getChildren() instanceof XdsConfig.XdsClusterConfig.EndpointConfig) {
            NameResolver.ConfigOrError configOrError = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(Arrays.asList(clusterConfig.getClusterResource().lbPolicyConfig()), (LoadBalancerRegistry)this.lbRegistry);
            if (configOrError.getError() != null) {
                return this.fail(Status.INTERNAL.withDescription(this.errorPrefix() + "Unable to parse the LB config: " + configOrError.getError()));
            }
            StatusOr<XdsEndpointResource.EdsUpdate> edsUpdate = CdsLoadBalancer2.getEdsUpdate(xdsConfig, this.clusterName);
            StatusOr<ClusterResolutionResult> statusOrResult = this.clusterState.edsUpdateToResult(this.clusterName, clusterConfig.getClusterResource(), configOrError.getConfig(), edsUpdate);
            if (!statusOrResult.hasValue()) {
                Status status = Status.UNAVAILABLE.withDescription(statusOrResult.getStatus().getDescription()).withCause(statusOrResult.getStatus().getCause());
                this.delegate.handleNameResolutionError(status);
                return status;
            }
            ClusterResolutionResult result = (ClusterResolutionResult)statusOrResult.getValue();
            List addresses = result.addresses;
            if (addresses.isEmpty()) {
                Status status = Status.UNAVAILABLE.withDescription("No usable endpoint from cluster: " + this.clusterName);
                this.delegate.handleNameResolutionError(status);
                return status;
            }
            Object gracefulConfig = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)this.lbRegistry.getProvider("priority_experimental"), (Object)new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(result.priorityChildConfigs), Collections.unmodifiableList(result.priorities)));
            return this.delegate.acceptResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(gracefulConfig).setAddresses(Collections.unmodifiableList(addresses)).build());
        }
        if (clusterConfig.getChildren() instanceof XdsConfig.XdsClusterConfig.AggregateConfig) {
            HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityChildConfigs = new HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig>();
            List<String> leafClusters = ((XdsConfig.XdsClusterConfig.AggregateConfig)clusterConfig.getChildren()).getLeafNames();
            for (String childCluster : leafClusters) {
                priorityChildConfigs.put(childCluster, new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)this.lbRegistry.getProvider("cds_experimental"), (Object)new CdsLoadBalancerProvider.CdsConfig(childCluster)), false));
            }
            Object gracefulConfig = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)this.lbRegistry.getProvider("priority_experimental"), (Object)new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(priorityChildConfigs), leafClusters));
            return this.delegate.acceptResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(gracefulConfig).build());
        }
        return this.fail(Status.INTERNAL.withDescription(this.errorPrefix() + "Unexpected cluster children type: " + clusterConfig.getChildren().getClass()));
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.delegate != null) {
            this.delegate.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
        }
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        this.delegate.shutdown();
        this.delegate = new GracefulSwitchLoadBalancer(this.helper);
        if (this.clusterSubscription != null) {
            this.clusterSubscription.close();
            this.clusterSubscription = null;
        }
    }

    @CheckReturnValue
    private Status fail(Status error) {
        this.delegate.shutdown();
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
        return Status.OK;
    }

    private String errorPrefix() {
        return "CdsLb for " + this.clusterName + ": ";
    }

    private static long fractionToFixedPoint(long numerator, long denominator) {
        long one = 0x80000000L;
        return numerator * one / denominator;
    }

    private static long fixedPointMultiply(long a, long b) {
        return a * b >> 31;
    }

    private static StatusOr<XdsEndpointResource.EdsUpdate> getEdsUpdate(XdsConfig xdsConfig, String cluster) {
        StatusOr clusterConfig = (StatusOr)xdsConfig.getClusters().get((Object)cluster);
        if (clusterConfig == null) {
            return StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("BUG: cluster resolver could not find cluster in xdsConfig"));
        }
        if (!clusterConfig.hasValue()) {
            return StatusOr.fromStatus((Status)clusterConfig.getStatus());
        }
        if (!(((XdsConfig.XdsClusterConfig)clusterConfig.getValue()).getChildren() instanceof XdsConfig.XdsClusterConfig.EndpointConfig)) {
            return StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("BUG: cluster resolver cluster with children of unknown type"));
        }
        XdsConfig.XdsClusterConfig.EndpointConfig endpointConfig = (XdsConfig.XdsClusterConfig.EndpointConfig)((XdsConfig.XdsClusterConfig)clusterConfig.getValue()).getChildren();
        return endpointConfig.getEndpoint();
    }

    private static String priorityName(String cluster, int priority) {
        return cluster + "[child" + priority + "]";
    }

    private static String localityName(Locality locality) {
        return "{region=\"" + locality.region() + "\", zone=\"" + locality.zone() + "\", sub_zone=\"" + locality.subZone() + "\"}";
    }

    private static Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> generatePriorityChildConfigs(String clusterName, XdsClusterResource.CdsUpdate discovery, Object endpointLbConfig, LoadBalancerRegistry lbRegistry, Map<String, Map<Locality, Integer>> prioritizedLocalityWeights, List<Endpoints.DropOverload> dropOverloads) {
        HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs = new HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig>();
        for (String priority : prioritizedLocalityWeights.keySet()) {
            ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(clusterName, discovery.edsServiceName(), discovery.lrsServerInfo(), discovery.maxConcurrentRequests(), dropOverloads, endpointLbConfig, discovery.upstreamTlsContext(), (Map<String, Struct>)discovery.filterMetadata(), discovery.backendMetricPropagation());
            LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
            Object priorityChildPolicy = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)clusterImplLbProvider, (Object)clusterImplConfig);
            if (discovery.outlierDetection() != null) {
                LoadBalancerProvider outlierDetectionProvider = lbRegistry.getProvider("outlier_detection_experimental");
                priorityChildPolicy = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)outlierDetectionProvider, (Object)CdsLoadBalancer2.buildOutlierDetectionLbConfig(discovery.outlierDetection(), priorityChildPolicy));
            }
            boolean isEds = discovery.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.EDS;
            PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(priorityChildPolicy, isEds);
            configs.put(priority, priorityChildConfig);
        }
        return configs;
    }

    private static OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig buildOutlierDetectionLbConfig(EnvoyServerProtoData.OutlierDetection outlierDetection, Object childConfig) {
        EnvoyServerProtoData.FailurePercentageEjection failurePercentage;
        EnvoyServerProtoData.SuccessRateEjection successRate;
        OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder configBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder();
        configBuilder.setChildConfig(childConfig);
        if (outlierDetection.intervalNanos() != null) {
            configBuilder.setIntervalNanos(outlierDetection.intervalNanos().longValue());
        }
        if (outlierDetection.baseEjectionTimeNanos() != null) {
            configBuilder.setBaseEjectionTimeNanos(outlierDetection.baseEjectionTimeNanos().longValue());
        }
        if (outlierDetection.maxEjectionTimeNanos() != null) {
            configBuilder.setMaxEjectionTimeNanos(outlierDetection.maxEjectionTimeNanos().longValue());
        }
        if (outlierDetection.maxEjectionPercent() != null) {
            configBuilder.setMaxEjectionPercent(outlierDetection.maxEjectionPercent().intValue());
        }
        if ((successRate = outlierDetection.successRateEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder successRateConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder();
            if (successRate.stdevFactor() != null) {
                successRateConfigBuilder.setStdevFactor(successRate.stdevFactor().intValue());
            }
            if (successRate.enforcementPercentage() != null) {
                successRateConfigBuilder.setEnforcementPercentage(successRate.enforcementPercentage().intValue());
            }
            if (successRate.minimumHosts() != null) {
                successRateConfigBuilder.setMinimumHosts(successRate.minimumHosts().intValue());
            }
            if (successRate.requestVolume() != null) {
                successRateConfigBuilder.setRequestVolume(successRate.requestVolume().intValue());
            }
            configBuilder.setSuccessRateEjection(successRateConfigBuilder.build());
        }
        if ((failurePercentage = outlierDetection.failurePercentageEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder failurePercentageConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder();
            if (failurePercentage.threshold() != null) {
                failurePercentageConfigBuilder.setThreshold(failurePercentage.threshold().intValue());
            }
            if (failurePercentage.enforcementPercentage() != null) {
                failurePercentageConfigBuilder.setEnforcementPercentage(failurePercentage.enforcementPercentage().intValue());
            }
            if (failurePercentage.minimumHosts() != null) {
                failurePercentageConfigBuilder.setMinimumHosts(failurePercentage.minimumHosts().intValue());
            }
            if (failurePercentage.requestVolume() != null) {
                failurePercentageConfigBuilder.setRequestVolume(failurePercentage.requestVolume().intValue());
            }
            configBuilder.setFailurePercentageEjection(failurePercentageConfigBuilder.build());
        }
        return configBuilder.build();
    }

    private static class ClusterResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityChildConfigs;
        private final List<String> priorities;

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs, List<String> priorities) {
            this.addresses = addresses;
            this.priorityChildConfigs = configs;
            this.priorities = priorities;
        }
    }

    private final class ClusterState {
        private Map<Locality, String> localityPriorityNames = Collections.emptyMap();
        int priorityNameGenId = 1;

        private ClusterState() {
        }

        StatusOr<ClusterResolutionResult> edsUpdateToResult(String clusterName, XdsClusterResource.CdsUpdate discovery, Object lbConfig, StatusOr<XdsEndpointResource.EdsUpdate> updateOr) {
            String priorityName;
            Endpoints.LocalityLbEndpoints localityLbInfo;
            HashMap<String, Long> priorityLocalityWeightSums;
            if (!updateOr.hasValue()) {
                return StatusOr.fromStatus((Status)updateOr.getStatus());
            }
            XdsEndpointResource.EdsUpdate update = (XdsEndpointResource.EdsUpdate)updateOr.getValue();
            CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update {0}", update);
            if (CdsLoadBalancer2.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0}: {1} localities, {2} drop categories", clusterName, update.localityLbEndpointsMap.size(), update.dropPolicies.size());
            }
            Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints = update.localityLbEndpointsMap;
            List<Endpoints.DropOverload> dropOverloads = update.dropPolicies;
            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
            HashMap prioritizedLocalityWeights = new HashMap();
            List<String> sortedPriorityNames = this.generatePriorityNames(clusterName, localityLbEndpoints);
            if (pickFirstWeightedShuffling) {
                priorityLocalityWeightSums = new HashMap<String, Long>(sortedPriorityNames.size() * 2);
                for (Locality locality : localityLbEndpoints.keySet()) {
                    localityLbInfo = localityLbEndpoints.get(locality);
                    priorityName = this.localityPriorityNames.get(locality);
                    Long sum = (Long)priorityLocalityWeightSums.get(priorityName);
                    if (sum == null) {
                        sum = 0L;
                    }
                    long weight = UnsignedInts.toLong((int)localityLbInfo.localityWeight());
                    priorityLocalityWeightSums.put(priorityName, sum + weight);
                }
            } else {
                priorityLocalityWeightSums = null;
            }
            for (Locality locality : localityLbEndpoints.keySet()) {
                localityLbInfo = localityLbEndpoints.get(locality);
                priorityName = this.localityPriorityNames.get(locality);
                boolean discard = true;
                long localityWeightSum = 0L;
                long endpointWeightSum = 0L;
                if (pickFirstWeightedShuffling) {
                    localityWeightSum = (Long)priorityLocalityWeightSums.get(priorityName);
                    for (Endpoints.LbEndpoint endpoint : localityLbInfo.endpoints()) {
                        if (!endpoint.isHealthy()) continue;
                        endpointWeightSum += UnsignedInts.toLong((int)endpoint.loadBalancingWeight());
                    }
                }
                for (Endpoints.LbEndpoint endpoint : localityLbInfo.endpoints()) {
                    EquivalentAddressGroup eag;
                    long weight;
                    if (!endpoint.isHealthy()) continue;
                    discard = false;
                    if (pickFirstWeightedShuffling) {
                        long endpointWeight;
                        long localityWeight = CdsLoadBalancer2.fractionToFixedPoint(UnsignedInts.toLong((int)localityLbInfo.localityWeight()), localityWeightSum);
                        weight = CdsLoadBalancer2.fixedPointMultiply(localityWeight, endpointWeight = CdsLoadBalancer2.fractionToFixedPoint(UnsignedInts.toLong((int)endpoint.loadBalancingWeight()), endpointWeightSum));
                        if (weight == 0L) {
                            weight = 1L;
                        }
                    } else {
                        weight = localityLbInfo.localityWeight();
                        if (endpoint.loadBalancingWeight() != 0) {
                            weight *= (long)endpoint.loadBalancingWeight();
                        }
                    }
                    String localityName = CdsLoadBalancer2.localityName(locality);
                    Attributes attr = endpoint.eag().getAttributes().toBuilder().set(XdsAttributes.ATTR_LOCALITY, (Object)locality).set(EquivalentAddressGroup.ATTR_LOCALITY_NAME, (Object)localityName).set(XdsAttributes.ATTR_LOCALITY_WEIGHT, (Object)localityLbInfo.localityWeight()).set(XdsAttributes.ATTR_SERVER_WEIGHT, (Object)weight).set(XdsInternalAttributes.ATTR_ADDRESS_NAME, (Object)endpoint.hostname()).build();
                    if (discovery.isHttp11ProxyAvailable()) {
                        ArrayList<SocketAddress> rewrittenAddresses = new ArrayList<SocketAddress>();
                        for (SocketAddress addr : endpoint.eag().getAddresses()) {
                            rewrittenAddresses.add(this.rewriteAddress(addr, endpoint.endpointMetadata(), localityLbInfo.localityMetadata()));
                        }
                        eag = new EquivalentAddressGroup(rewrittenAddresses, attr);
                    } else {
                        eag = new EquivalentAddressGroup(endpoint.eag().getAddresses(), attr);
                    }
                    eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, localityName));
                    addresses.add(eag);
                }
                if (discard) {
                    CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints", locality);
                    continue;
                }
                if (!prioritizedLocalityWeights.containsKey(priorityName)) {
                    prioritizedLocalityWeights.put(priorityName, new HashMap());
                }
                ((Map)prioritizedLocalityWeights.get(priorityName)).put(locality, localityLbInfo.localityWeight());
            }
            if (prioritizedLocalityWeights.isEmpty()) {
                CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0} has no usable priority/locality/endpoint", clusterName);
            }
            sortedPriorityNames.retainAll(prioritizedLocalityWeights.keySet());
            Map priorityChildConfigs = CdsLoadBalancer2.generatePriorityChildConfigs(clusterName, discovery, lbConfig, CdsLoadBalancer2.this.lbRegistry, prioritizedLocalityWeights, dropOverloads);
            return StatusOr.fromValue((Object)new ClusterResolutionResult(addresses, priorityChildConfigs, sortedPriorityNames));
        }

        private SocketAddress rewriteAddress(SocketAddress addr, ImmutableMap<String, Object> endpointMetadata, ImmutableMap<String, Object> localityMetadata) {
            SocketAddress proxyAddress;
            if (!(addr instanceof InetSocketAddress)) {
                return addr;
            }
            try {
                proxyAddress = (SocketAddress)endpointMetadata.get((Object)"envoy.http11_proxy_transport_socket.proxy_address");
                if (proxyAddress == null) {
                    proxyAddress = (SocketAddress)localityMetadata.get((Object)"envoy.http11_proxy_transport_socket.proxy_address");
                }
            }
            catch (ClassCastException e) {
                return addr;
            }
            if (proxyAddress == null) {
                return addr;
            }
            return HttpConnectProxiedSocketAddress.newBuilder().setTargetAddress((InetSocketAddress)addr).setProxyAddress(proxyAddress).build();
        }

        private List<String> generatePriorityNames(String name, Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints) {
            TreeMap todo = new TreeMap();
            for (Locality locality : localityLbEndpoints.keySet()) {
                int priority = localityLbEndpoints.get(locality).priority();
                if (!todo.containsKey(priority)) {
                    todo.put(priority, new ArrayList());
                }
                ((List)todo.get(priority)).add(locality);
            }
            HashMap<Locality, String> newNames = new HashMap<Locality, String>();
            HashSet<String> usedNames = new HashSet<String>();
            ArrayList<String> ret = new ArrayList<String>();
            for (Integer priority : todo.keySet()) {
                String foundName = "";
                for (Locality locality : (List)todo.get(priority)) {
                    if (!this.localityPriorityNames.containsKey(locality) || !usedNames.add(this.localityPriorityNames.get(locality))) continue;
                    foundName = this.localityPriorityNames.get(locality);
                    break;
                }
                if ("".equals(foundName)) {
                    foundName = CdsLoadBalancer2.priorityName(name, this.priorityNameGenId++);
                }
                for (Locality locality : (List)todo.get(priority)) {
                    newNames.put(locality, foundName);
                }
                ret.add(foundName);
            }
            this.localityPriorityNames = newNames;
            return ret;
        }
    }
}

