/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.Internal;
import io.grpc.InternalLogId;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonParser;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.EnvoyProtoData;
import io.grpc.xds.client.Locality;
import io.grpc.xds.client.XdsInitializationException;
import io.grpc.xds.client.XdsLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Internal
public abstract class BootstrapperImpl
extends Bootstrapper {
    public static final String GRPC_EXPERIMENTAL_XDS_FALLBACK = "GRPC_EXPERIMENTAL_XDS_FALLBACK";
    public static final String GRPC_EXPERIMENTAL_XDS_DATA_ERROR_HANDLING = "GRPC_EXPERIMENTAL_XDS_DATA_ERROR_HANDLING";
    @VisibleForTesting
    public static final String CLIENT_FEATURE_DISABLE_OVERPROVISIONING = "envoy.lb.does_not_support_overprovisioning";
    @VisibleForTesting
    public static final String CLIENT_FEATURE_RESOURCE_IN_SOTW = "xds.config.resource-in-sotw";
    private static final String SERVER_FEATURE_IGNORE_RESOURCE_DELETION = "ignore_resource_deletion";
    private static final String SERVER_FEATURE_TRUSTED_XDS_SERVER = "trusted_xds_server";
    private static final String SERVER_FEATURE_RESOURCE_TIMER_IS_TRANSIENT_ERROR = "resource_timer_is_transient_error";
    private static final String SERVER_FEATURE_FAIL_ON_DATA_ERRORS = "fail_on_data_errors";
    @VisibleForTesting
    static boolean enableXdsFallback = GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_XDS_FALLBACK", (boolean)true);
    @VisibleForTesting
    public static boolean xdsDataErrorHandlingEnabled = GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_XDS_DATA_ERROR_HANDLING", (boolean)false);
    protected final XdsLogger logger;
    protected FileReader reader = LocalFileReader.INSTANCE;

    protected BootstrapperImpl() {
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"bootstrapper", null));
    }

    protected abstract String getJsonContent() throws IOException, XdsInitializationException;

    protected abstract Object getImplSpecificConfig(Map<String, ?> var1, String var2) throws XdsInitializationException;

    @Override
    public Bootstrapper.BootstrapInfo bootstrap() throws XdsInitializationException {
        Map rawBootstrap;
        String jsonContent;
        try {
            jsonContent = this.getJsonContent();
        }
        catch (IOException e) {
            throw new XdsInitializationException("Fail to read bootstrap file", e);
        }
        try {
            rawBootstrap = (Map)JsonParser.parse((String)jsonContent);
        }
        catch (IOException e) {
            throw new XdsInitializationException("Failed to parse JSON", e);
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Bootstrap configuration:\n{0}", rawBootstrap);
        return this.bootstrap(rawBootstrap);
    }

    @Override
    public Bootstrapper.BootstrapInfo bootstrap(Map<String, ?> rawData) throws XdsInitializationException {
        return this.bootstrapBuilder(rawData).build();
    }

    protected Bootstrapper.BootstrapInfo.Builder bootstrapBuilder(Map<String, ?> rawData) throws XdsInitializationException {
        Bootstrapper.BootstrapInfo.Builder builder = Bootstrapper.BootstrapInfo.builder();
        List rawServerConfigs = JsonUtil.getList(rawData, (String)"xds_servers");
        if (rawServerConfigs == null) {
            throw new XdsInitializationException("Invalid bootstrap: 'xds_servers' does not exist.");
        }
        ImmutableList servers = this.parseServerInfos(rawServerConfigs, this.logger);
        if (servers.size() > 1 && !enableXdsFallback) {
            servers = ImmutableList.of((Object)servers.get(0));
        }
        builder.servers((List<Bootstrapper.ServerInfo>)servers);
        EnvoyProtoData.Node.Builder nodeBuilder = EnvoyProtoData.Node.newBuilder();
        Map rawNode = JsonUtil.getObject(rawData, (String)"node");
        if (rawNode != null) {
            Object rawLocality;
            Map metadata;
            String cluster;
            String id = JsonUtil.getString((Map)rawNode, (String)"id");
            if (id != null) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Node id: {0}", id);
                nodeBuilder.setId(id);
            }
            if ((cluster = JsonUtil.getString((Map)rawNode, (String)"cluster")) != null) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Node cluster: {0}", cluster);
                nodeBuilder.setCluster(cluster);
            }
            if ((metadata = JsonUtil.getObject((Map)rawNode, (String)"metadata")) != null) {
                nodeBuilder.setMetadata(metadata);
            }
            if ((rawLocality = JsonUtil.getObject((Map)rawNode, (String)"locality")) != null) {
                String region = "";
                String zone = "";
                String subZone = "";
                if (rawLocality.containsKey("region")) {
                    region = JsonUtil.getString((Map)rawLocality, (String)"region");
                }
                if (rawLocality.containsKey("zone")) {
                    zone = JsonUtil.getString((Map)rawLocality, (String)"zone");
                }
                if (rawLocality.containsKey("sub_zone")) {
                    subZone = JsonUtil.getString((Map)rawLocality, (String)"sub_zone");
                }
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Locality region: {0}, zone: {1}, subZone: {2}", region, zone, subZone);
                Locality locality = Locality.create(region, zone, subZone);
                nodeBuilder.setLocality(locality);
            }
        }
        GrpcUtil.GrpcBuildVersion buildVersion = GrpcUtil.getGrpcBuildVersion();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Build version: {0}", buildVersion);
        nodeBuilder.setBuildVersion(buildVersion.toString());
        nodeBuilder.setUserAgentName(buildVersion.getUserAgent());
        nodeBuilder.setUserAgentVersion(buildVersion.getImplementationVersion());
        nodeBuilder.addClientFeatures(CLIENT_FEATURE_DISABLE_OVERPROVISIONING);
        nodeBuilder.addClientFeatures(CLIENT_FEATURE_RESOURCE_IN_SOTW);
        builder.node(nodeBuilder.build());
        Map certProvidersBlob = JsonUtil.getObject(rawData, (String)"certificate_providers");
        if (certProvidersBlob != null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} cert providers", certProvidersBlob.size());
            HashMap<String, Bootstrapper.CertificateProviderInfo> certProviders = new HashMap<String, Bootstrapper.CertificateProviderInfo>(certProvidersBlob.size());
            for (String name : certProvidersBlob.keySet()) {
                Map valueMap = JsonUtil.getObject((Map)certProvidersBlob, (String)name);
                String pluginName = BootstrapperImpl.checkForNull(JsonUtil.getString((Map)valueMap, (String)"plugin_name"), "plugin_name");
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "cert provider: {0}, plugin name: {1}", name, pluginName);
                Map config = BootstrapperImpl.checkForNull(JsonUtil.getObject((Map)valueMap, (String)"config"), "config");
                Bootstrapper.CertificateProviderInfo certificateProviderInfo = Bootstrapper.CertificateProviderInfo.create(pluginName, config);
                certProviders.put(name, certificateProviderInfo);
            }
            builder.certProviders(certProviders);
        }
        String serverResourceId = JsonUtil.getString(rawData, (String)"server_listener_resource_name_template");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "server_listener_resource_name_template: {0}", serverResourceId);
        builder.serverListenerResourceNameTemplate(serverResourceId);
        String clientDefaultListener = JsonUtil.getString(rawData, (String)"client_default_listener_resource_name_template");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "client_default_listener_resource_name_template: {0}", clientDefaultListener);
        if (clientDefaultListener != null) {
            builder.clientDefaultListenerResourceNameTemplate(clientDefaultListener);
        }
        Map rawAuthoritiesMap = JsonUtil.getObject(rawData, (String)"authorities");
        ImmutableMap.Builder authorityInfoMapBuilder = ImmutableMap.builder();
        if (rawAuthoritiesMap != null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} xDS server authorities", rawAuthoritiesMap.size());
            for (String authorityName : rawAuthoritiesMap.keySet()) {
                Object authorityServers;
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "xDS server authority: {0}", authorityName);
                Map rawAuthority = JsonUtil.getObject((Map)rawAuthoritiesMap, (String)authorityName);
                String clientListnerTemplate = JsonUtil.getString((Map)rawAuthority, (String)"client_listener_resource_name_template");
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "client_listener_resource_name_template: {0}", clientListnerTemplate);
                String prefix = "xdstp://" + authorityName + "/";
                if (clientListnerTemplate == null) {
                    clientListnerTemplate = prefix + "envoy.config.listener.v3.Listener/%s";
                } else if (!clientListnerTemplate.startsWith(prefix)) {
                    throw new XdsInitializationException("client_listener_resource_name_template: '" + clientListnerTemplate + "' does not start with " + prefix);
                }
                List rawAuthorityServers = JsonUtil.getList((Map)rawAuthority, (String)"xds_servers");
                if (rawAuthorityServers == null || rawAuthorityServers.isEmpty()) {
                    authorityServers = servers;
                } else {
                    if (rawAuthorityServers.size() > 1 && !enableXdsFallback) {
                        rawAuthorityServers = ImmutableList.of(rawAuthorityServers.get(0));
                    }
                    authorityServers = this.parseServerInfos(rawAuthorityServers, this.logger);
                }
                authorityInfoMapBuilder.put((Object)authorityName, (Object)Bootstrapper.AuthorityInfo.create(clientListnerTemplate, (List<Bootstrapper.ServerInfo>)authorityServers));
            }
            builder.authorities((Map<String, Bootstrapper.AuthorityInfo>)authorityInfoMapBuilder.buildOrThrow());
        }
        return builder;
    }

    private List<Bootstrapper.ServerInfo> parseServerInfos(List<?> rawServerConfigs, XdsLogger logger) throws XdsInitializationException {
        logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} xDS servers", rawServerConfigs.size());
        ImmutableList.Builder servers = ImmutableList.builder();
        List serverConfigList = JsonUtil.checkObjectList(rawServerConfigs);
        for (Map serverConfig : serverConfigList) {
            String serverUri = JsonUtil.getString((Map)serverConfig, (String)"server_uri");
            if (serverUri == null) {
                throw new XdsInitializationException("Invalid bootstrap: missing 'server_uri'");
            }
            logger.log(XdsLogger.XdsLogLevel.INFO, "xDS server URI: {0}", serverUri);
            Object implSpecificConfig = this.getImplSpecificConfig(serverConfig, serverUri);
            boolean resourceTimerIsTransientError = false;
            boolean ignoreResourceDeletion = false;
            boolean failOnDataErrors = false;
            List serverFeatures = JsonUtil.getList((Map)serverConfig, (String)"server_features");
            if (serverFeatures != null) {
                logger.log(XdsLogger.XdsLogLevel.INFO, "Server features: {0}", serverFeatures);
                if (serverFeatures.contains(SERVER_FEATURE_IGNORE_RESOURCE_DELETION)) {
                    ignoreResourceDeletion = true;
                }
                resourceTimerIsTransientError = xdsDataErrorHandlingEnabled && serverFeatures.contains(SERVER_FEATURE_RESOURCE_TIMER_IS_TRANSIENT_ERROR);
                failOnDataErrors = xdsDataErrorHandlingEnabled && serverFeatures.contains(SERVER_FEATURE_FAIL_ON_DATA_ERRORS);
            }
            servers.add((Object)Bootstrapper.ServerInfo.create(serverUri, implSpecificConfig, ignoreResourceDeletion, serverFeatures != null && serverFeatures.contains(SERVER_FEATURE_TRUSTED_XDS_SERVER), resourceTimerIsTransientError, failOnDataErrors));
        }
        return servers.build();
    }

    @VisibleForTesting
    public void setFileReader(FileReader reader) {
        this.reader = reader;
    }

    private static <T> T checkForNull(T value, String fieldName) throws XdsInitializationException {
        if (value == null) {
            throw new XdsInitializationException("Invalid bootstrap: '" + fieldName + "' does not exist.");
        }
        return value;
    }

    protected static enum LocalFileReader implements FileReader
    {
        INSTANCE;


        @Override
        public String readFile(String path) throws IOException {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        }
    }

    public static interface FileReader {
        public String readFile(String var1) throws IOException;
    }
}

