/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Internal;
import io.grpc.Status;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.security.SslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.X509TrustManager;

@Internal
public abstract class DynamicSslContextProvider
extends SslContextProvider {
    protected final List<SslContextProvider.Callback> pendingCallbacks = new ArrayList<SslContextProvider.Callback>();
    @Nullable
    protected final CertificateValidationContext staticCertificateValidationContext;
    @Nullable
    protected AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndTrustManager;
    protected boolean autoSniSanValidationDoesNotApply;

    protected DynamicSslContextProvider(EnvoyServerProtoData.BaseTlsContext tlsContext, CertificateValidationContext staticCertValidationContext) {
        super(tlsContext);
        this.staticCertificateValidationContext = staticCertValidationContext;
    }

    @Nullable
    public AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> getSslContextAndTrustManager() {
        return this.sslContextAndTrustManager;
    }

    protected abstract CertificateValidationContext generateCertificateValidationContext();

    public void setAutoSniSanValidationDoesNotApply() {
        this.autoSniSanValidationDoesNotApply = true;
    }

    protected abstract AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> getSslContextBuilderAndTrustManager(CertificateValidationContext var1) throws CertificateException, IOException, CertStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateSslContext() {
        try {
            List<SslContextProvider.Callback> pendingCallbacksCopy;
            AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndExtendedX09TrustManagerCopy;
            CertificateValidationContext localCertValidationContext = this.generateCertificateValidationContext();
            AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> sslContextBuilderAndTm = this.getSslContextBuilderAndTrustManager(localCertValidationContext);
            CommonTlsContext commonTlsContext = this.getCommonTlsContext();
            if (commonTlsContext != null && commonTlsContext.getAlpnProtocolsCount() > 0) {
                ProtocolStringList alpnList = commonTlsContext.getAlpnProtocolsList();
                ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable)alpnList);
                sslContextBuilderAndTm.getKey().applicationProtocolConfig(apn);
            }
            List<SslContextProvider.Callback> list = this.pendingCallbacks;
            synchronized (list) {
                sslContextAndExtendedX09TrustManagerCopy = this.sslContextAndTrustManager = new AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager>(sslContextBuilderAndTm.getKey().build(), sslContextBuilderAndTm.getValue());
                pendingCallbacksCopy = this.clonePendingCallbacksAndClear();
            }
            this.makePendingCallbacks(sslContextAndExtendedX09TrustManagerCopy, pendingCallbacksCopy);
        }
        catch (Exception e) {
            this.onError(Status.fromThrowable((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    protected final void callPerformCallback(SslContextProvider.Callback callback, final AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndTmCopy) {
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> get() {
                return sslContextAndTmCopy;
            }
        }, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addCallback(SslContextProvider.Callback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextCopy = null;
        List<SslContextProvider.Callback> list = this.pendingCallbacks;
        synchronized (list) {
            if (this.sslContextAndTrustManager != null) {
                sslContextCopy = this.sslContextAndTrustManager;
            } else {
                this.pendingCallbacks.add(callback);
            }
        }
        if (sslContextCopy != null) {
            this.callPerformCallback(callback, sslContextCopy);
        }
    }

    private final void makePendingCallbacks(AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndExtendedX509TrustManagerCopy, List<SslContextProvider.Callback> pendingCallbacksCopy) {
        for (SslContextProvider.Callback callback : pendingCallbacksCopy) {
            this.callPerformCallback(callback, sslContextAndExtendedX509TrustManagerCopy);
        }
    }

    public final void onError(Status error) {
        for (SslContextProvider.Callback callback : this.clonePendingCallbacksAndClear()) {
            callback.onException((Throwable)error.asException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SslContextProvider.Callback> clonePendingCallbacksAndClear() {
        List<SslContextProvider.Callback> list = this.pendingCallbacks;
        synchronized (list) {
            ImmutableList copy = ImmutableList.copyOf(this.pendingCallbacks);
            this.pendingCallbacks.clear();
            return copy;
        }
    }
}

