/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public final class SoftParseEnumTypeAdapter<T extends Enum>
extends TypeAdapter {
    private final Class<T> clazz;
    private final T defaultValue;

    public SoftParseEnumTypeAdapter(Class<T> clazz, T defaultValue) {
        this.clazz = clazz;
        this.defaultValue = defaultValue;
    }

    public void write(JsonWriter jsonWriter, Object o) throws IOException {
        jsonWriter.value(o.toString());
    }

    public Object read(JsonReader jsonReader) throws IOException {
        try {
            return Enum.valueOf(this.clazz, jsonReader.nextString());
        }
        catch (IllegalArgumentException ex) {
            return this.defaultValue;
        }
    }
}

