/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.CodegenEvent;
import io.helidon.codegen.CodegenLogger;
import io.helidon.codegen.CodegenOptions;
import io.helidon.common.types.TypeName;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

class AptLogger
implements CodegenLogger {
    private final System.Logger logger;
    private final Messager messager;
    private final ProcessingEnvironment env;

    AptLogger(ProcessingEnvironment env, CodegenOptions options) {
        this.messager = env.getMessager();
        this.env = env;
        this.logger = System.getLogger(AptLogger.class.getName());
    }

    public void log(CodegenEvent event) {
        switch (event.level()) {
            case TRACE: 
            case DEBUG: {
                this.logSystem(event);
                break;
            }
            case INFO: {
                this.logSystem(event);
                this.logApt(event);
                break;
            }
            case WARNING: 
            case ERROR: {
                this.logApt(event);
                break;
            }
            default: {
                this.logSystem(event);
            }
        }
    }

    private void logApt(CodegenEvent event) {
        Diagnostic.Kind kind = this.mapKind(event.level());
        if (kind == Diagnostic.Kind.OTHER) {
            return;
        }
        List objects = event.objects();
        this.messager.printMessage(kind, event.message(), this.findElement(objects), this.findAnnotation(objects), this.findAnnotationValue(objects));
    }

    private AnnotationValue findAnnotationValue(List<Object> objects) {
        for (Object object : objects) {
            if (!(object instanceof AnnotationValue)) continue;
            AnnotationValue value = (AnnotationValue)object;
            return value;
        }
        return null;
    }

    private AnnotationMirror findAnnotation(List<Object> objects) {
        for (Object object : objects) {
            if (!(object instanceof AnnotationMirror)) continue;
            AnnotationMirror mirror = (AnnotationMirror)object;
            return mirror;
        }
        return null;
    }

    private Element findElement(List<Object> objects) {
        for (Object object : objects) {
            if (!(object instanceof Element)) continue;
            Element e = (Element)object;
            return e;
        }
        for (Object object : objects) {
            if (!(object instanceof TypeName)) continue;
            TypeName t = (TypeName)object;
            TypeElement element = this.env.getElementUtils().getTypeElement(t.declaredName());
            if (element == null) continue;
            return element;
        }
        return null;
    }

    private Diagnostic.Kind mapKind(System.Logger.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case System.Logger.Level.TRACE, System.Logger.Level.DEBUG, System.Logger.Level.ALL, System.Logger.Level.OFF -> Diagnostic.Kind.OTHER;
            case System.Logger.Level.INFO -> Diagnostic.Kind.NOTE;
            case System.Logger.Level.WARNING -> Diagnostic.Kind.WARNING;
            case System.Logger.Level.ERROR -> Diagnostic.Kind.ERROR;
        };
    }

    private void logSystem(CodegenEvent event) {
        if (this.logger.isLoggable(event.level())) {
            this.logger.log(event.level(), event.message(), (Throwable)event.throwable().orElse(null));
        }
    }
}

