/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.crypto;

import io.helidon.common.Base64Value;
import io.helidon.common.crypto.CryptoCommonConstants;
import io.helidon.common.crypto.CryptoException;
import java.util.regex.Matcher;

public interface CommonCipher {
    public Base64Value encrypt(Base64Value var1);

    public Base64Value decrypt(Base64Value var1);

    default public String encryptToString(Base64Value message) {
        return "helidon:2:" + this.encrypt(message).toBase64();
    }

    default public Base64Value decryptFromString(String cipherText) {
        Matcher matcher = CryptoCommonConstants.PREFIX_PATTERN.matcher(cipherText);
        if (matcher.matches()) {
            return this.decrypt(Base64Value.createFromEncoded((String)matcher.group(2)));
        }
        throw new CryptoException("String does not contain Helidon prefix: " + cipherText);
    }
}

