/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.tls.RevocationConfigBlueprint;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.tls.RevocationConfigBlueprint")
public interface RevocationConfig
extends RevocationConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RevocationConfig instance) {
        return (Builder)RevocationConfig.builder().from(instance);
    }

    public static RevocationConfig create(Config config) {
        return ((Builder)RevocationConfig.builder().config(config)).buildPrototype();
    }

    public static RevocationConfig create() {
        return RevocationConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, RevocationConfig>
    implements io.helidon.common.Builder<Builder, RevocationConfig> {
        private Builder() {
        }

        public RevocationConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.RevocationConfigImpl(this);
        }

        public RevocationConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends RevocationConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean checkOnlyEndEntity = false;
        private boolean enabled = false;
        private boolean fallbackEnabled = true;
        private boolean preferCrlOverOcsp = false;
        private boolean softFailEnabled = false;
        private Config config;
        private URI ocspResponderUri;

        protected BuilderBase() {
        }

        public BUILDER from(RevocationConfig prototype) {
            this.enabled(prototype.enabled());
            this.preferCrlOverOcsp(prototype.preferCrlOverOcsp());
            this.checkOnlyEndEntity(prototype.checkOnlyEndEntity());
            this.fallbackEnabled(prototype.fallbackEnabled());
            this.softFailEnabled(prototype.softFailEnabled());
            this.ocspResponderUri(prototype.ocspResponderUri());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            this.preferCrlOverOcsp(builder.preferCrlOverOcsp());
            this.checkOnlyEndEntity(builder.checkOnlyEndEntity());
            this.fallbackEnabled(builder.fallbackEnabled());
            this.softFailEnabled(builder.softFailEnabled());
            builder.ocspResponderUri().ifPresent(this::ocspResponderUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("prefer-crl-over-ocsp").as(Boolean.class).ifPresent(this::preferCrlOverOcsp);
            config.get("check-only-end-entity").as(Boolean.class).ifPresent(this::checkOnlyEndEntity);
            config.get("fallback-enabled").as(Boolean.class).ifPresent(this::fallbackEnabled);
            config.get("soft-fail-enabled").as(Boolean.class).ifPresent(this::softFailEnabled);
            config.get("ocsp-responder-uri").as(URI.class).ifPresent(this::ocspResponderUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER preferCrlOverOcsp(boolean preferCrlOverOcsp) {
            this.preferCrlOverOcsp = preferCrlOverOcsp;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER checkOnlyEndEntity(boolean checkOnlyEndEntity) {
            this.checkOnlyEndEntity = checkOnlyEndEntity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fallbackEnabled(boolean fallbackEnabled) {
            this.fallbackEnabled = fallbackEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER softFailEnabled(boolean softFailEnabled) {
            this.softFailEnabled = softFailEnabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOcspResponderUri() {
            this.ocspResponderUri = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ocspResponderUri(URI ocspResponderUri) {
            Objects.requireNonNull(ocspResponderUri);
            this.ocspResponderUri = ocspResponderUri;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean preferCrlOverOcsp() {
            return this.preferCrlOverOcsp;
        }

        public boolean checkOnlyEndEntity() {
            return this.checkOnlyEndEntity;
        }

        public boolean fallbackEnabled() {
            return this.fallbackEnabled;
        }

        public boolean softFailEnabled() {
            return this.softFailEnabled;
        }

        public Optional<URI> ocspResponderUri() {
            return Optional.ofNullable(this.ocspResponderUri);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "RevocationConfigBuilder{enabled=" + this.enabled + ",preferCrlOverOcsp=" + this.preferCrlOverOcsp + ",checkOnlyEndEntity=" + this.checkOnlyEndEntity + ",fallbackEnabled=" + this.fallbackEnabled + ",softFailEnabled=" + this.softFailEnabled + ",ocspResponderUri=" + String.valueOf(this.ocspResponderUri) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER ocspResponderUri(Optional<? extends URI> ocspResponderUri) {
            Objects.requireNonNull(ocspResponderUri);
            this.ocspResponderUri = ocspResponderUri.map(URI.class::cast).orElse(this.ocspResponderUri);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class RevocationConfigImpl
        implements RevocationConfig {
            private final boolean checkOnlyEndEntity;
            private final boolean enabled;
            private final boolean fallbackEnabled;
            private final boolean preferCrlOverOcsp;
            private final boolean softFailEnabled;
            private final Optional<URI> ocspResponderUri;

            protected RevocationConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.preferCrlOverOcsp = builder.preferCrlOverOcsp();
                this.checkOnlyEndEntity = builder.checkOnlyEndEntity();
                this.fallbackEnabled = builder.fallbackEnabled();
                this.softFailEnabled = builder.softFailEnabled();
                this.ocspResponderUri = builder.ocspResponderUri();
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public boolean preferCrlOverOcsp() {
                return this.preferCrlOverOcsp;
            }

            @Override
            public boolean checkOnlyEndEntity() {
                return this.checkOnlyEndEntity;
            }

            @Override
            public boolean fallbackEnabled() {
                return this.fallbackEnabled;
            }

            @Override
            public boolean softFailEnabled() {
                return this.softFailEnabled;
            }

            @Override
            public Optional<URI> ocspResponderUri() {
                return this.ocspResponderUri;
            }

            public String toString() {
                return "RevocationConfig{enabled=" + this.enabled + ",preferCrlOverOcsp=" + this.preferCrlOverOcsp + ",checkOnlyEndEntity=" + this.checkOnlyEndEntity + ",fallbackEnabled=" + this.fallbackEnabled + ",softFailEnabled=" + this.softFailEnabled + ",ocspResponderUri=" + String.valueOf(this.ocspResponderUri) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RevocationConfig)) {
                    return false;
                }
                RevocationConfig other = (RevocationConfig)o;
                return this.enabled == other.enabled() && this.preferCrlOverOcsp == other.preferCrlOverOcsp() && this.checkOnlyEndEntity == other.checkOnlyEndEntity() && this.fallbackEnabled == other.fallbackEnabled() && this.softFailEnabled == other.softFailEnabled() && Objects.equals(this.ocspResponderUri, other.ocspResponderUri());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.preferCrlOverOcsp, this.checkOnlyEndEntity, this.fallbackEnabled, this.softFailEnabled, this.ocspResponderUri);
            }
        }
    }
}

