/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.pki.Keys;
import io.helidon.common.tls.RevocationConfig;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsClientAuth;
import io.helidon.common.tls.TlsConfigDecorator;
import io.helidon.common.tls.TlsManager;
import io.helidon.common.tls.spi.TlsManagerProvider;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

@Prototype.Blueprint(decorator=TlsConfigDecorator.class)
@Prototype.Configured
interface TlsConfigBlueprint
extends Prototype.Factory<Tls> {
    public static final String DEFAULT_PROTOCOL = "TLS";
    public static final int DEFAULT_SESSION_CACHE_SIZE = 20480;
    public static final String DEFAULT_SESSION_TIMEOUT = "PT24H";

    @Prototype.FactoryMethod
    public static Optional<PrivateKey> createPrivateKey(Keys config) {
        return config.privateKey();
    }

    @Prototype.FactoryMethod
    public static List<X509Certificate> createPrivateKeyCertChain(Keys config) {
        return config.certChain();
    }

    @Prototype.FactoryMethod
    public static List<X509Certificate> createTrust(Keys config) {
        return config.certs();
    }

    public Optional<SSLContext> sslContext();

    @Option.Configured
    public Optional<PrivateKey> privateKey();

    @Option.Singular
    @Option.Configured(value="private-key")
    public List<X509Certificate> privateKeyCertChain();

    @Option.Singular
    @Option.Configured
    public List<X509Certificate> trust();

    @Option.Configured
    @Option.Provider(value=TlsManagerProvider.class, discoverServices=false)
    public TlsManager manager();

    public Optional<SecureRandom> secureRandom();

    public Optional<SSLParameters> sslParameters();

    @Option.Configured
    public Optional<String> secureRandomProvider();

    @Option.Configured
    public Optional<String> secureRandomAlgorithm();

    @Option.Configured
    public Optional<String> keyManagerFactoryAlgorithm();

    public Optional<String> keyManagerFactoryProvider();

    @Option.Configured
    public Optional<String> trustManagerFactoryAlgorithm();

    public Optional<String> trustManagerFactoryProvider();

    @Option.Singular
    public List<String> applicationProtocols();

    @Option.Configured
    @Option.Default(value={"HTTPS"})
    public String endpointIdentificationAlgorithm();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean enabled();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean trustAll();

    @Option.Configured
    @Option.Default(value={"NONE"})
    public TlsClientAuth clientAuth();

    @Option.Configured
    @Option.Default(value={"TLS"})
    public String protocol();

    @Option.Configured
    public Optional<String> provider();

    @Option.Configured(value="cipher-suite")
    @Option.Singular(value="enabledCipherSuite")
    public List<String> enabledCipherSuites();

    @Option.Configured(value="protocols")
    @Option.Singular
    public List<String> enabledProtocols();

    @Option.Configured
    @Option.DefaultInt(value={20480})
    public int sessionCacheSize();

    @Option.Configured
    @Option.Default(value={"PT24H"})
    public Duration sessionTimeout();

    @Option.Configured
    public Optional<String> internalKeystoreType();

    @Option.Configured
    public Optional<String> internalKeystoreProvider();

    @Option.Configured
    public Optional<RevocationConfig> revocation();
}

