/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.builder.api.Prototype;
import io.helidon.common.tls.ConfiguredTlsManager;
import io.helidon.common.tls.TlsConfig;
import io.helidon.common.tls.TlsManager;
import javax.net.ssl.SSLParameters;

class TlsConfigDecorator
implements Prototype.BuilderDecorator<TlsConfig.BuilderBase<?, ?>> {
    TlsConfigDecorator() {
    }

    public void decorate(TlsConfig.BuilderBase<?, ?> target) {
        TlsConfigDecorator.sslParameters(target);
        TlsManager theManager = target.manager().orElse(null);
        if (theManager == null) {
            theManager = new ConfiguredTlsManager();
            target.manager(theManager);
        }
    }

    static void sslParameters(TlsConfig.BuilderBase<?, ?> target) {
        if (target.sslParameters().isPresent()) {
            return;
        }
        SSLParameters parameters = new SSLParameters();
        if (!target.applicationProtocols().isEmpty()) {
            parameters.setApplicationProtocols(target.applicationProtocols().toArray(new String[0]));
        }
        if (!target.enabledProtocols().isEmpty()) {
            parameters.setProtocols(target.enabledProtocols().toArray(new String[0]));
        }
        if (!target.enabledCipherSuites().isEmpty()) {
            parameters.setCipherSuites(target.enabledCipherSuites().toArray(new String[0]));
        }
        if ("NONE".equals(target.endpointIdentificationAlgorithm())) {
            parameters.setEndpointIdentificationAlgorithm("");
        } else {
            parameters.setEndpointIdentificationAlgorithm(target.endpointIdentificationAlgorithm());
        }
        switch (target.clientAuth()) {
            case REQUIRED: {
                parameters.setNeedClientAuth(true);
                break;
            }
            case OPTIONAL: {
                parameters.setWantClientAuth(true);
                break;
            }
        }
        target.sslParameters(parameters);
    }
}

