/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriEncoding;
import io.helidon.common.uri.UriPathHelper;
import io.helidon.common.uri.UriPathMatrix;
import io.helidon.common.uri.UriPathNoParam;
import io.helidon.common.uri.UriPathSegment;
import java.util.ArrayList;
import java.util.List;

public interface UriPath {
    public static UriPath createRelative(UriPath uriPath, String relativePath) {
        return new UriPathNoParam(uriPath.absolute(), relativePath);
    }

    public static UriPath create(String rawPath) {
        String rawPathNoParams = UriPathHelper.stripMatrixParams(rawPath);
        if (rawPath.length() == rawPathNoParams.length()) {
            return new UriPathNoParam(rawPath);
        }
        return new UriPathMatrix(rawPath, rawPathNoParams);
    }

    public static UriPath createFromDecoded(String decodedPath) {
        String pathNoParams = UriPathHelper.stripMatrixParams(decodedPath);
        if (pathNoParams.length() == decodedPath.length()) {
            return new UriPathNoParam(UriEncoding.encode(decodedPath, UriEncoding.Type.PATH));
        }
        return new UriPathMatrix(UriEncoding.encode(decodedPath, UriEncoding.Type.PATH), UriEncoding.encode(pathNoParams, UriEncoding.Type.PATH));
    }

    public static UriPath root() {
        return UriPath.create("/");
    }

    public String rawPath();

    public String rawPathNoParams();

    public String path();

    public Parameters matrixParameters();

    public UriPath absolute();

    default public List<UriPathSegment> segments() {
        String[] segmentStrings = this.rawPath().split("/");
        ArrayList<UriPathSegment> segments = new ArrayList<UriPathSegment>(segmentStrings.length);
        for (String segmentString : segmentStrings) {
            segments.add(UriPathSegment.create(segmentString));
        }
        return List.copyOf(segments);
    }

    public void validate();
}

