/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import java.io.IOException;
import java.io.ObjectInputFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public final class SerializationConfig {
    static final String PROP_WRONG_CONFIG_ACTION = "helidon.serialFilter.failure.action";
    static final String PROP_NO_CONFIG_ACTION = "helidon.serialFilter.missing.action";
    static final String PROP_PATTERN = "helidon.serialFilter.pattern";
    static final String PROP_TRACE = "helidon.serialFilter.trace";
    static final String PROP_IGNORE_FILES = "helidon.serialFilter.ignoreFiles";
    private static final String PROPERTY_FILE = "META-INF/helidon/serial-config.properties";
    private static final String REJECT_ALL_PATTERN = "!*";
    private static final System.Logger LOGGER = System.getLogger(SerializationConfig.class.getName());
    private static final AtomicReference<ConfigOptions> EXISTING_CONFIG = new AtomicReference();
    private static final AtomicBoolean RUNTIME_CONFIGURED = new AtomicBoolean();
    private final ConfigOptions options;

    private SerializationConfig(Builder builder) {
        this.options = new ConfigOptions(builder.onWrongConfig, builder.onNoConfig, builder.filterPattern, builder.traceSerialization);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void configureRuntime() {
        if (RUNTIME_CONFIGURED.compareAndSet(false, true)) {
            SerializationConfig.builder().build().configureDefaults();
        }
    }

    private void configureDefaults() {
        if (EXISTING_CONFIG.compareAndSet(null, this.options)) {
            this.doConfigure();
        } else {
            LOGGER.log(System.Logger.Level.TRACE, "Will not configure defaults, there is already a serialization config in place: " + String.valueOf(EXISTING_CONFIG.get()));
        }
    }

    public void configure() {
        if (!EXISTING_CONFIG.compareAndSet(null, this.options)) {
            ConfigOptions existingOptions = EXISTING_CONFIG.get();
            if (this.options.equals(existingOptions)) {
                return;
            }
            throw new IllegalArgumentException("You are trying to reconfigure serialization config with different options. This is not possible, as global filter can only be configured once.Existing options: " + String.valueOf(existingOptions) + ", your options: " + String.valueOf(this.options));
        }
        this.doConfigure();
    }

    ConfigOptions options() {
        return this.options;
    }

    private void doConfigure() {
        ObjectInputFilter currentFilter = ObjectInputFilter.Config.getSerialFilter();
        if (currentFilter == null) {
            switch (this.options.onNoConfig().ordinal()) {
                case 0: {
                    throw new IllegalStateException("There is no global serial filter configured. To automatically configure a filter, please set system property helidon.serialFilter.missing.action to \"configure\"");
                }
                case 1: {
                    AtomicBoolean logged = new AtomicBoolean();
                    this.configureTracingFilter(this.options, it -> {
                        if (it.serialClass() != null && logged.compareAndSet(false, true)) {
                            LOGGER.log(System.Logger.Level.WARNING, "Deserialization attempted for class " + it.serialClass().getName() + ", yet there is no global serial filter configured. To automatically configure a filter, please set system property \"helidon.serialFilter.missing.action\" to \"configure\"");
                        }
                        return ObjectInputFilter.Status.UNDECIDED;
                    });
                    return;
                }
                case 3: {
                    LOGGER.log(System.Logger.Level.DEBUG, "Ignoring that there is no global serial filter configured. To automatically configure a filter, please set system property helidon.serialFilter.missing.action to \"configure\"");
                    this.configureTracingFilter(this.options, null);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported no configuration action: " + String.valueOf((Object)this.options.onNoConfig()));
                }
                case 2: 
            }
            this.configureGlobalFilter(this.options);
        } else {
            Action action = this.options.onWrongConfig();
            if (action == Action.IGNORE) {
                LOGGER.log(System.Logger.Level.DEBUG, "Existing serialization config is ignored by Helidon.");
                return;
            }
            this.validateExistingFilter(currentFilter, action);
        }
    }

    private void validateExistingFilter(ObjectInputFilter currentFilter, Action action) {
        String currentFilterString = System.getProperty("jdk.serialFilter");
        if (currentFilterString == null) {
            LOGGER.log(System.Logger.Level.DEBUG, "Programmatic filter configured: " + String.valueOf(currentFilter));
            ObjectInputFilter.Status status = currentFilter.checkInput(new ObjectInputFilter.FilterInfo(this){

                @Override
                public Class<?> serialClass() {
                    return SerializationConfig.class;
                }

                @Override
                public long arrayLength() {
                    return 0L;
                }

                @Override
                public long depth() {
                    return 0L;
                }

                @Override
                public long references() {
                    return 0L;
                }

                @Override
                public long streamBytes() {
                    return 0L;
                }
            });
            if (status == ObjectInputFilter.Status.ALLOWED || status == ObjectInputFilter.Status.UNDECIDED) {
                this.handleBadFilter(action, "Custom JDK Serialization Filter is not configured to reject all classes. Helidon can only run with allow-list. Please add '!*' as the last pattern.");
            }
        } else {
            LOGGER.log(System.Logger.Level.DEBUG, "System property filter configured: " + currentFilterString);
            if (SerializationConfig.hasRejectAll(currentFilterString)) {
                return;
            }
            this.handleBadFilter(action, "jdk.serialFilter is configured without rejecting all other classes. Helidon can only run with allow-lists. Please add '!*' as the last pattern.");
        }
    }

    private static boolean hasRejectAll(String pattern) {
        return pattern.startsWith("!*;") || pattern.contains(";!*;") || pattern.endsWith(";!*") || pattern.equals(REJECT_ALL_PATTERN);
    }

    private void handleBadFilter(Action action, String message) {
        switch (action.ordinal()) {
            case 0: {
                throw new IllegalStateException(message);
            }
            case 1: {
                LOGGER.log(System.Logger.Level.WARNING, message);
                break;
            }
            case 2: {
                throw new IllegalStateException("Cannot reconfigure current global deserialization filter. Original message: " + message);
            }
            case 3: {
                LOGGER.log(System.Logger.Level.DEBUG, "Ignoring global deserialization filter issue. Original message: " + message);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected action to handle bad global deserialization filter: " + String.valueOf((Object)action));
            }
        }
    }

    private void configureTracingFilter(ConfigOptions options, ObjectInputFilter existing) {
        ObjectInputFilter filter = existing;
        switch (options.traceSerialization().ordinal()) {
            case 0: {
                if (existing == null) {
                    filter = this.emptyFilter();
                }
                ObjectInputFilter.Config.setSerialFilter(new TracingObjectInputFilter(filter, true));
                break;
            }
            case 1: {
                if (existing == null) {
                    filter = this.emptyFilter();
                }
                ObjectInputFilter.Config.setSerialFilter(new TracingObjectInputFilter(filter, false));
                break;
            }
            case 2: {
                if (existing == null) {
                    return;
                }
                ObjectInputFilter.Config.setSerialFilter(existing);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported trace serialization option: " + String.valueOf((Object)options.traceSerialization()));
            }
        }
    }

    private ObjectInputFilter emptyFilter() {
        return filterInfo -> ObjectInputFilter.Status.UNDECIDED;
    }

    private void configureGlobalFilter(ConfigOptions options) {
        String pattern = options.filterPattern();
        LOGGER.log(System.Logger.Level.DEBUG, "Using serialization pattern " + pattern);
        ObjectInputFilter filter = ObjectInputFilter.Config.createFilter(pattern);
        this.configureTracingFilter(options, filter);
    }

    static final class ConfigOptions {
        private final Action onWrongConfig;
        private final Action onNoConfig;
        private final String filterPattern;
        private final TraceOption traceSerialization;

        private ConfigOptions(Action onWrongConfig, Action onNoConfig, String filterPattern, TraceOption traceSerialization) {
            this.onWrongConfig = onWrongConfig;
            this.onNoConfig = onNoConfig;
            this.filterPattern = filterPattern;
            this.traceSerialization = traceSerialization;
        }

        Action onWrongConfig() {
            return this.onWrongConfig;
        }

        Action onNoConfig() {
            return this.onNoConfig;
        }

        String filterPattern() {
            return this.filterPattern;
        }

        TraceOption traceSerialization() {
            return this.traceSerialization;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigOptions that = (ConfigOptions)o;
            return this.onWrongConfig == that.onWrongConfig && this.onNoConfig == that.onNoConfig && this.filterPattern.equals(that.filterPattern) && this.traceSerialization == that.traceSerialization;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.onWrongConfig, this.onNoConfig, this.filterPattern, this.traceSerialization});
        }

        public String toString() {
            return "ConfigOptions{onWrongConfig=" + String.valueOf((Object)this.onWrongConfig) + ", onNoConfig=" + String.valueOf((Object)this.onNoConfig) + ", filterPattern='" + this.filterPattern + "', traceSerialization=" + String.valueOf((Object)this.traceSerialization) + "}";
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, SerializationConfig> {
        private Action onWrongConfig = Builder.configuredAction("helidon.serialFilter.failure.action", Action.FAIL);
        private Action onNoConfig = Builder.configuredAction("helidon.serialFilter.missing.action", Action.CONFIGURE);
        private String filterPattern = System.getProperty("helidon.serialFilter.pattern");
        private TraceOption traceSerialization = Builder.configuredTrace(TraceOption.NONE);
        private boolean ignoreFiles = Boolean.getBoolean("helidon.serialFilter.ignoreFiles");

        private Builder() {
        }

        private static Action configuredAction(String sysProp, Action defaultValue) {
            String property = System.getProperty(sysProp);
            if (property == null) {
                return defaultValue;
            }
            try {
                return Action.valueOf(property.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                List validActions = Arrays.stream(Action.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.toList());
                LOGGER.log(System.Logger.Level.WARNING, "System property \"" + sysProp + "\" is configured to \"" + property + "\", which is not a valid Action. Valid actions: " + String.valueOf(validActions) + ". Using: " + defaultValue.toString().toLowerCase());
                return defaultValue;
            }
        }

        private static TraceOption configuredTrace(TraceOption defaultValue) {
            String property = System.getProperty(SerializationConfig.PROP_TRACE);
            if (property == null) {
                return defaultValue;
            }
            try {
                return TraceOption.valueOf(property.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                List validTraceOptions = Arrays.stream(TraceOption.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.toList());
                LOGGER.log(System.Logger.Level.WARNING, "System property \"helidon.serialFilter.trace\" is configured to \"" + property + "\", which is not a valid TraceOption. Valid trace options: " + String.valueOf(validTraceOptions) + ". Using: " + defaultValue.toString().toLowerCase());
                return defaultValue;
            }
        }

        @Override
        public SerializationConfig build() {
            this.filterPattern = this.getPattern();
            return new SerializationConfig(this);
        }

        public Builder onWrongConfig(Action onWrongConfig) {
            this.onWrongConfig = onWrongConfig;
            return this;
        }

        public Builder onNoConfig(Action onNoConfig) {
            this.onNoConfig = onNoConfig;
            return this;
        }

        public Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public Builder traceSerialization(TraceOption traceSerialization) {
            this.traceSerialization = traceSerialization;
            return this;
        }

        public Builder ignoreFiles(boolean ignoreFiles) {
            this.ignoreFiles = ignoreFiles;
            return this;
        }

        private String getPattern() {
            String currentFilterString = System.getProperty("jdk.serialFilter");
            if (currentFilterString != null) {
                if (this.filterPattern != null && !this.filterPattern.isBlank()) {
                    throw new IllegalArgumentException("jdk.serialFilter system property is configured and an explicit filter pattern is configured as well. This is not supported.");
                }
                return SerializationConfig.REJECT_ALL_PATTERN;
            }
            if (this.ignoreFiles) {
                if (this.filterPattern == null || this.filterPattern.isBlank()) {
                    return SerializationConfig.REJECT_ALL_PATTERN;
                }
                if (SerializationConfig.hasRejectAll(this.filterPattern)) {
                    return this.filterPattern;
                }
                return this.filterPattern + ";!*";
            }
            LinkedList<String> parts = new LinkedList<String>();
            try {
                Enumeration<URL> resources = SerializationConfig.class.getClassLoader().getResources(SerializationConfig.PROPERTY_FILE);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    Properties props = new Properties();
                    props.load(url.openStream());
                    String pattern = props.getProperty("pattern");
                    if (pattern == null) {
                        LOGGER.log(System.Logger.Level.WARNING, "Could not find 'pattern' property in " + String.valueOf(url));
                        continue;
                    }
                    if (pattern.isBlank()) continue;
                    parts.add(pattern);
                }
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.WARNING, "Could not find META-INF/helidon/serial-config.properties resources", (Throwable)e);
            }
            if (this.filterPattern != null && !this.filterPattern.isBlank()) {
                parts.add(this.filterPattern.trim());
            }
            if (!parts.contains(SerializationConfig.REJECT_ALL_PATTERN)) {
                parts.add(SerializationConfig.REJECT_ALL_PATTERN);
            }
            return String.join((CharSequence)";", parts);
        }
    }

    public static enum Action {
        FAIL,
        WARN,
        CONFIGURE,
        IGNORE;

    }

    public static enum TraceOption {
        BASIC,
        FULL,
        NONE;

    }

    private static class TracingObjectInputFilter
    implements ObjectInputFilter {
        private static final System.Logger LOGGER = System.getLogger(TracingObjectInputFilter.class.getName());
        private final Set<Class<?>> reportedClasses = Collections.newSetFromMap(new ConcurrentHashMap());
        private final ObjectInputFilter delegate;
        private final boolean basic;

        private TracingObjectInputFilter(ObjectInputFilter filter, boolean basic) {
            this.delegate = filter;
            this.basic = basic;
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            Class<?> clazz = filterInfo.serialClass();
            if (clazz == null && this.basic) {
                return this.delegate.checkInput(filterInfo);
            }
            ObjectInputFilter.Status result = this.delegate.checkInput(filterInfo);
            if (clazz == null) {
                return result;
            }
            if (!this.reportedClasses.add(clazz) && this.basic) {
                return result;
            }
            LOGGER.log(System.Logger.Level.INFO, String.valueOf((Object)result) + " class: " + String.valueOf(clazz) + ", arrayLength: " + filterInfo.arrayLength() + ", depth: " + filterInfo.depth() + ", references: " + filterInfo.references() + ", streamBytes: " + filterInfo.streamBytes());
            return result;
        }
    }
}

