/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.NativeImageHelper;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckResponse;
import io.helidon.health.HealthCheckType;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;

public class DeadlockHealthCheck
implements HealthCheck {
    private static final System.Logger LOGGER = System.getLogger(DeadlockHealthCheck.class.getName());
    private static final String NAME = "deadlock";
    private static final String PATH = "deadlock";
    private final ThreadMXBean threadBean;
    private final boolean disabled;

    DeadlockHealthCheck(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
        this.disabled = NativeImageHelper.isNativeImage();
    }

    public static DeadlockHealthCheck create(ThreadMXBean threadBean) {
        return new DeadlockHealthCheck(threadBean);
    }

    public static DeadlockHealthCheck create() {
        return DeadlockHealthCheck.create(ManagementFactory.getThreadMXBean());
    }

    public HealthCheckType type() {
        return HealthCheckType.LIVENESS;
    }

    public String name() {
        return "deadlock";
    }

    public String path() {
        return "deadlock";
    }

    public HealthCheckResponse call() {
        if (this.disabled) {
            LOGGER.log(System.Logger.Level.TRACE, "Running in graal native image, this health-check always returns up.");
            return HealthCheckResponse.builder().detail("enabled", (Object)"false").detail("description", (Object)"in native image").status(HealthCheckResponse.Status.UP).build();
        }
        HealthCheckResponse.Builder builder = HealthCheckResponse.builder();
        try {
            long[] deadlockedThreads = this.threadBean.findDeadlockedThreads();
            if (deadlockedThreads != null) {
                builder.status(HealthCheckResponse.Status.DOWN);
                LOGGER.log(System.Logger.Level.TRACE, "Health check observed deadlocked threads: " + Arrays.toString(deadlockedThreads));
            }
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.TRACE, "Error invoking ThreadMXBean to find deadlocks; cannot complete this healthcheck", e);
            builder.status(HealthCheckResponse.Status.ERROR);
        }
        return builder.build();
    }
}

