/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckResponse;
import io.helidon.health.HealthCheckType;
import io.helidon.health.checks.DiskSpaceHealthCheck;
import java.util.Formatter;
import java.util.Locale;

public class HeapMemoryHealthCheck
implements HealthCheck {
    public static final double DEFAULT_THRESHOLD = 98.0;
    static final String CONFIG_KEY_HEAP_PREFIX = "heapMemory";
    static final String CONFIG_KEY_THRESHOLD_PERCENT_SUFFIX = "thresholdPercent";
    public static final String CONFIG_KEY_THRESHOLD_PERCENT = "helidon.health.heapMemory.thresholdPercent";
    private final Runtime rt;
    private final double thresholdPercent;

    HeapMemoryHealthCheck(Runtime runtime, double thresholdPercent) {
        this.rt = runtime;
        this.thresholdPercent = thresholdPercent;
    }

    private HeapMemoryHealthCheck(Builder builder) {
        this.thresholdPercent = builder.threshold;
        this.rt = Runtime.getRuntime();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HeapMemoryHealthCheck create() {
        return HeapMemoryHealthCheck.builder().build();
    }

    public HealthCheckType type() {
        return HealthCheckType.LIVENESS;
    }

    public String name() {
        return CONFIG_KEY_HEAP_PREFIX;
    }

    public String path() {
        return "heapmemory";
    }

    public HealthCheckResponse call() {
        Formatter formatter = new Formatter(Locale.US);
        long freeMemory = this.rt.freeMemory();
        long totalMemory = this.rt.totalMemory();
        long maxMemory = this.rt.maxMemory();
        long usedMemory = totalMemory - freeMemory;
        long threshold = (long)(this.thresholdPercent / 100.0 * (double)maxMemory);
        return HealthCheckResponse.builder().status(threshold >= usedMemory).detail("percentFree", (Object)formatter.format("%.2f%%", 100.0 * ((double)(maxMemory - usedMemory) / (double)maxMemory)).toString()).detail("free", (Object)DiskSpaceHealthCheck.format(freeMemory)).detail("freeBytes", (Object)freeMemory).detail("max", (Object)DiskSpaceHealthCheck.format(maxMemory)).detail("maxBytes", (Object)maxMemory).detail("total", (Object)DiskSpaceHealthCheck.format(totalMemory)).detail("totalBytes", (Object)totalMemory).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, HeapMemoryHealthCheck> {
        private double threshold = 98.0;

        private Builder() {
        }

        public HeapMemoryHealthCheck build() {
            return new HeapMemoryHealthCheck(this);
        }

        public Builder thresholdPercent(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder config(Config config) {
            config.get(HeapMemoryHealthCheck.CONFIG_KEY_THRESHOLD_PERCENT).asDouble().ifPresent(this::thresholdPercent);
            return this;
        }
    }
}

