/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.StatusHelper;
import java.util.Objects;

public class Status {
    public static final Status CONTINUE_100 = new Status(100, "Continue", true);
    public static final Status SWITCHING_PROTOCOLS_101 = new Status(101, "Switching Protocols", true);
    public static final Status OK_200 = new Status(200, "OK", true);
    public static final Status CREATED_201 = new Status(201, "Created", true);
    public static final Status ACCEPTED_202 = new Status(202, "Accepted", true);
    public static final Status NON_AUTHORITATIVE_INFORMATION_203 = new Status(203, "Non-Authoritative Information", true);
    public static final Status NO_CONTENT_204 = new Status(204, "No Content", true);
    public static final Status RESET_CONTENT_205 = new Status(205, "Reset Content", true);
    public static final Status PARTIAL_CONTENT_206 = new Status(206, "Partial Content", true);
    public static final Status MULTI_STATUS_207 = new Status(207, "Multi-Status", true);
    public static final Status MOVED_PERMANENTLY_301 = new Status(301, "Moved Permanently", true);
    public static final Status FOUND_302 = new Status(302, "Found", true);
    public static final Status SEE_OTHER_303 = new Status(303, "See Other", true);
    public static final Status NOT_MODIFIED_304 = new Status(304, "Not Modified", true);
    public static final Status USE_PROXY_305 = new Status(305, "Use Proxy", true);
    public static final Status TEMPORARY_REDIRECT_307 = new Status(307, "Temporary Redirect", true);
    public static final Status PERMANENT_REDIRECT_308 = new Status(308, "Permanent Redirect", true);
    public static final Status BAD_REQUEST_400 = new Status(400, "Bad Request", true);
    public static final Status UNAUTHORIZED_401 = new Status(401, "Unauthorized", true);
    public static final Status PAYMENT_REQUIRED_402 = new Status(402, "Payment Required", true);
    public static final Status FORBIDDEN_403 = new Status(403, "Forbidden", true);
    public static final Status NOT_FOUND_404 = new Status(404, "Not Found", true);
    public static final Status METHOD_NOT_ALLOWED_405 = new Status(405, "Method Not Allowed", true);
    public static final Status NOT_ACCEPTABLE_406 = new Status(406, "Not Acceptable", true);
    public static final Status PROXY_AUTHENTICATION_REQUIRED_407 = new Status(407, "Proxy Authentication Required", true);
    public static final Status REQUEST_TIMEOUT_408 = new Status(408, "Request Timeout", true);
    public static final Status CONFLICT_409 = new Status(409, "Conflict", true);
    public static final Status GONE_410 = new Status(410, "Gone", true);
    public static final Status LENGTH_REQUIRED_411 = new Status(411, "Length Required", true);
    public static final Status PRECONDITION_FAILED_412 = new Status(412, "Precondition Failed", true);
    public static final Status REQUEST_ENTITY_TOO_LARGE_413 = new Status(413, "Request Entity Too Large", true);
    public static final Status REQUEST_URI_TOO_LONG_414 = new Status(414, "Request-URI Too Long", true);
    public static final Status UNSUPPORTED_MEDIA_TYPE_415 = new Status(415, "Unsupported Media Type", true);
    public static final Status REQUESTED_RANGE_NOT_SATISFIABLE_416 = new Status(416, "Requested Range Not Satisfiable", true);
    public static final Status EXPECTATION_FAILED_417 = new Status(417, "Expectation Failed", true);
    public static final Status I_AM_A_TEAPOT_418 = new Status(418, "I'm a teapot", true);
    public static final Status MISDIRECTED_REQUEST_421 = new Status(421, "Misdirected Request", true);
    public static final Status UNPROCESSABLE_CONTENT_422 = new Status(422, "Unprocessable Content", true);
    public static final Status LOCKED_423 = new Status(423, "Locked", true);
    public static final Status FAILED_DEPENDENCY_424 = new Status(424, "Failed Dependency", true);
    public static final Status UPGRADE_REQUIRED_426 = new Status(426, "Upgrade Required", true);
    public static final Status PRECONDITION_REQUIRED_428 = new Status(428, "Precondition Required", true);
    public static final Status TOO_MANY_REQUESTS_429 = new Status(429, "Too Many Requests", true);
    public static final Status INTERNAL_SERVER_ERROR_500 = new Status(500, "Internal Server Error", true);
    public static final Status NOT_IMPLEMENTED_501 = new Status(501, "Not Implemented", true);
    public static final Status BAD_GATEWAY_502 = new Status(502, "Bad Gateway", true);
    public static final Status SERVICE_UNAVAILABLE_503 = new Status(503, "Service Unavailable", true);
    public static final Status GATEWAY_TIMEOUT_504 = new Status(504, "Gateway Timeout", true);
    public static final Status HTTP_VERSION_NOT_SUPPORTED_505 = new Status(505, "HTTP Version Not Supported", true);
    public static final Status INSUFFICIENT_STORAGE_507 = new Status(507, "Insufficient Storage", true);
    public static final Status LOOP_DETECTED_508 = new Status(508, "Loop Detected", true);
    public static final Status NOT_EXTENDED_510 = new Status(510, "Not Extended", true);
    public static final Status NETWORK_AUTHENTICATION_REQUIRED_511 = new Status(511, "Network Authentication Required", true);
    private final int code;
    private final String reason;
    private final Family family;
    private final String codeText;
    private final String stringValue;

    private Status(int statusCode, String reasonPhrase, boolean instance) {
        this.code = statusCode;
        this.reason = reasonPhrase;
        this.family = Family.of(statusCode);
        this.codeText = String.valueOf(this.code);
        this.stringValue = this.code + " " + this.reason;
        if (instance) {
            StatusHelper.add(this);
        }
    }

    private Status(int statusCode, String reasonPhrase, Family family, String codeText) {
        this.code = statusCode;
        this.reason = reasonPhrase;
        this.family = family;
        this.codeText = codeText;
        this.stringValue = this.code + " " + this.reason;
    }

    public static Status create(int statusCode) {
        Status found = StatusHelper.find(statusCode);
        if (found == null) {
            return Status.createNew(Family.of(statusCode), statusCode, "", String.valueOf(statusCode));
        }
        return found;
    }

    public static Status create(int statusCode, String reasonPhrase) {
        Status found = StatusHelper.find(statusCode);
        if (found == null) {
            return Status.createNew(Family.of(statusCode), statusCode, reasonPhrase, String.valueOf(statusCode));
        }
        if (reasonPhrase == null) {
            return found;
        }
        if (found.reasonPhrase().equalsIgnoreCase(reasonPhrase)) {
            return found;
        }
        return Status.createNew(found.family(), statusCode, reasonPhrase, found.codeText());
    }

    private static Status createNew(Family family, int statusCode, String reasonPhrase, String codeText) {
        return new Status(statusCode, reasonPhrase, family, codeText);
    }

    public int code() {
        return this.code;
    }

    public Family family() {
        return this.family;
    }

    public String reasonPhrase() {
        return this.reason;
    }

    public String codeText() {
        return this.codeText;
    }

    public String toString() {
        return this.stringValue;
    }

    public String text() {
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return this.code == status.code && this.reason.equals(status.reason);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.reason);
    }

    static {
        StatusHelper.statusesDone();
    }

    public static enum Family {
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR,
        OTHER;


        public static Family of(int statusCode) {
            return switch (statusCode / 100) {
                case 1 -> INFORMATIONAL;
                case 2 -> SUCCESSFUL;
                case 3 -> REDIRECTION;
                case 4 -> CLIENT_ERROR;
                case 5 -> SERVER_ERROR;
                default -> OTHER;
            };
        }
    }
}

