/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

final class Utils {
    private Utils() {
    }

    static List<String> tokenize(char separator, String quoteChars, boolean includeEmptyTokens, String text) {
        char[] quotes = quoteChars == null ? new char[]{} : quoteChars.toCharArray();
        StringBuilder token = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean quoted = false;
        char lastQuoteCharacter = ' ';
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (quoted) {
                if (ch == lastQuoteCharacter) {
                    quoted = false;
                }
                token.append(ch);
                continue;
            }
            if (ch == separator) {
                if (includeEmptyTokens || token.length() > 0) {
                    result.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            for (char quote : quotes) {
                if (ch != quote) continue;
                quoted = true;
                lastQuoteCharacter = ch;
                break;
            }
            token.append(ch);
        }
        if (includeEmptyTokens || token.length() > 0) {
            result.add(token.toString());
        }
        return result;
    }

    static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] buff = new byte[byteBuffer.remaining()];
        return Utils.toByteArray(byteBuffer, buff, 0);
    }

    static byte[] toByteArray(ByteBuffer byteBuffer, byte[] buff, int destPos) {
        if (byteBuffer.hasArray()) {
            System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), buff, destPos, buff.length);
        } else {
            byteBuffer.get(buff, destPos, byteBuffer.remaining());
        }
        return buff;
    }
}

