/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.media.EntityReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class JsonpReader<T extends JsonStructure>
implements EntityReader<T> {
    private final JsonReaderFactory readerFactory;

    JsonpReader(JsonReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
    }

    public T read(GenericType<T> type, InputStream stream, Headers headers) {
        return this.read(type, stream, this.contentTypeCharset(headers));
    }

    public T read(GenericType<T> type, InputStream stream, Headers requestHeaders, Headers responseHeaders) {
        return this.read(type, stream, this.contentTypeCharset(responseHeaders));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T read(GenericType<T> type, InputStream in, Charset charset) {
        try (InputStreamReader r = new InputStreamReader(in, charset);){
            JsonStructure jsonStructure = (JsonStructure)type.cast((Object)this.readerFactory.createReader((Reader)r).read());
            return (T)jsonStructure;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Charset contentTypeCharset(Headers headers) {
        return headers.contentType().flatMap(HttpMediaType::charset).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }
}

