/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import io.helidon.common.Weight;
import io.helidon.common.config.Config;
import io.helidon.integrations.langchain4j.providers.openai.OpenAi;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiEmbeddingModelConfig;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@Service.Named(value="*")
@Weight(value=90.0)
@Service.Singleton
public class OpenAiEmbeddingModelFactory
implements Service.ServicesFactory<OpenAiEmbeddingModel> {
    private final Supplier<Optional<OpenAiEmbeddingModel>> model;

    OpenAiEmbeddingModelFactory(@Service.Named(value="open-ai.embedding-model") Supplier<Optional<Tokenizer>> openAiChatModelTokenizer, @Service.Named(value="open-ai") Supplier<Optional<Tokenizer>> openAiTokenizer, Supplier<Optional<Tokenizer>> tokenizer, @Service.Named(value="open-ai.embedding-model") Supplier<Optional<Proxy>> openAiChatModelProxy, @Service.Named(value="open-ai") Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy, Config config) {
        OpenAiEmbeddingModelConfig.Builder configBuilder = (OpenAiEmbeddingModelConfig.Builder)OpenAiEmbeddingModelConfig.builder().config(config.get("langchain4j.open-ai.embedding-model"));
        this.model = () -> OpenAiEmbeddingModelFactory.buildModel(configBuilder, openAiChatModelTokenizer, openAiTokenizer, tokenizer, openAiChatModelProxy, openAiProxy, proxy);
    }

    public static OpenAiEmbeddingModel create(OpenAiEmbeddingModelConfig config) {
        if (!config.enabled()) {
            throw new IllegalStateException("Cannot create a model when the configuration is disabled.");
        }
        OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder builder = OpenAiEmbeddingModel.builder();
        config.baseUrl().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).baseUrl(arg_0));
        config.apiKey().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).apiKey(arg_0));
        config.organizationId().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).organizationId(arg_0));
        config.modelName().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).modelName(arg_0));
        config.dimensions().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).dimensions(arg_0));
        config.user().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).user(arg_0));
        config.timeout().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).timeout(arg_0));
        config.maxRetries().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).maxRetries(arg_0));
        config.logRequests().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).logRequests(arg_0));
        config.logResponses().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).logResponses(arg_0));
        config.tokenizer().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).tokenizer(arg_0));
        config.proxy().ifPresent(arg_0 -> ((OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder)builder).proxy(arg_0));
        if (!config.customHeaders().isEmpty()) {
            builder.customHeaders(config.customHeaders());
        }
        return builder.build();
    }

    public List<Service.QualifiedInstance<OpenAiEmbeddingModel>> services() {
        Optional<OpenAiEmbeddingModel> modelOptional = this.model.get();
        if (modelOptional.isEmpty()) {
            return List.of();
        }
        OpenAiEmbeddingModel theModel = modelOptional.get();
        return List.of(Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[0]), Service.QualifiedInstance.create((Object)theModel, (Qualifier[])new Qualifier[]{OpenAi.OPEN_AI_QUALIFIER}));
    }

    private static Optional<OpenAiEmbeddingModel> buildModel(OpenAiEmbeddingModelConfig.Builder configBuilder, Supplier<Optional<Tokenizer>> openAiModelTokenizer, Supplier<Optional<Tokenizer>> openAiTokenizer, Supplier<Optional<Tokenizer>> tokenizer, Supplier<Optional<Proxy>> openAiModelProxy, Supplier<Optional<Proxy>> openAiProxy, Supplier<Optional<Proxy>> proxy) {
        if (!configBuilder.enabled()) {
            return Optional.empty();
        }
        openAiModelTokenizer.get().or(openAiTokenizer).or(tokenizer).ifPresent(configBuilder::tokenizer);
        openAiModelProxy.get().or(openAiProxy).or(proxy).ifPresent(configBuilder::proxy);
        return Optional.of(OpenAiEmbeddingModelFactory.create(configBuilder.build()));
    }
}

