/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.jul;

import java.util.HashMap;
import java.util.Map;

public class JulMdc {
    private static final ThreadLocal<Map<String, String>> MDC_PROPERTIES = ThreadLocal.withInitial(HashMap::new);

    private JulMdc() {
        throw new IllegalStateException("This class cannot be instantiated");
    }

    static void put(String key, String value) {
        MDC_PROPERTIES.get().put(key, value);
    }

    public static String get(String key) {
        return MDC_PROPERTIES.get().get(key);
    }

    static void remove(String key) {
        MDC_PROPERTIES.get().remove(key);
    }

    static void clear() {
        MDC_PROPERTIES.get().clear();
    }

    static Map<String, String> properties() {
        return new HashMap<String, String>(MDC_PROPERTIES.get());
    }

    static void properties(Map<String, String> properties) {
        MDC_PROPERTIES.set(new HashMap<String, String>(properties));
    }
}

