/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.Bucket;
import io.helidon.metrics.api.Clock;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.NoOpWrapper;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import io.helidon.metrics.api.ValueAtPercentile;
import io.helidon.metrics.api.Wrapper;
import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

class NoOpMeter
implements Meter,
NoOpWrapper {
    private final Id id;
    private final String unit;
    private final String description;
    private final Meter.Type type;
    private final String scope;

    private NoOpMeter(Builder<?, ?> builder) {
        this(new Id(builder.name, builder.tags), builder.unit, builder.description, builder.type, builder.scope);
    }

    private NoOpMeter(Id id, String baseUnit, String description, Meter.Type type, String scope) {
        this.id = id;
        this.unit = Objects.requireNonNullElse(baseUnit, "");
        this.description = Objects.requireNonNullElse(description, "");
        this.type = type;
        this.scope = scope;
    }

    static Map<String, String> tagsMap(Iterable<Tag> tags) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        tags.forEach(tag -> result.put(tag.key(), tag.value()));
        return result;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Optional<String> baseUnit() {
        return Optional.ofNullable(this.unit);
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Meter.Type type() {
        return this.type;
    }

    @Override
    public Optional<String> scope() {
        return Optional.ofNullable(this.scope);
    }

    private static Id create(Builder<?, ?> builder) {
        return new Id(builder.name(), builder.tags());
    }

    static class Id
    implements Meter.Id {
        private final String name;
        private final List<Tag> tags = new ArrayList<Tag>();

        private Id(String name, Map<String, String> tags) {
            this.name = name;
            tags.forEach((k, v) -> this.tags.add(Tag.create(k, v)));
            this.tags.sort(Comparator.comparing(Tag::key));
        }

        static Id create(String name, Map<String, String> tags) {
            return new Id(name, tags);
        }

        @Override
        public String name() {
            return this.name;
        }

        public List<Tag> tags() {
            return Collections.unmodifiableList(this.tags);
        }

        String tag(String key) {
            return this.tags.stream().filter(t -> t.key().equals(key)).map(Tag::value).findFirst().orElse(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.name.equals(id.name) && this.tags.equals(id.tags);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.tags);
        }
    }

    static abstract class Builder<B extends Builder<B, M>, M extends Meter>
    implements Wrapper {
        private final String name;
        private final Map<String, String> tags = new TreeMap<String, String>();
        private final Meter.Type type;
        private String description;
        private String unit;
        private String scope;

        private Builder(String name, Meter.Type type) {
            this.name = name;
            this.type = type;
        }

        abstract M build();

        public B tags(Iterable<Tag> tags) {
            tags.forEach(tag -> this.tags.put(tag.key(), tag.value()));
            return this.identity();
        }

        public B addTag(Tag tag) {
            this.tags.put(tag.key(), tag.value());
            return this.identity();
        }

        public B description(String description) {
            this.description = description;
            return this.identity();
        }

        public B baseUnit(String unit) {
            this.unit = unit;
            return this.identity();
        }

        public B scope(String scope) {
            this.scope = scope;
            return this.identity();
        }

        public B identity() {
            return (B)this;
        }

        public String name() {
            return this.name;
        }

        public Map<String, String> tags() {
            return new TreeMap<String, String>(this.tags);
        }

        public Optional<String> baseUnit() {
            return Optional.ofNullable(this.unit);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public Optional<String> scope() {
            return Optional.ofNullable(this.scope);
        }

        @Override
        public <R> R unwrap(Class<? extends R> c) {
            return c.cast(this);
        }
    }

    static class DistributionStatisticsConfig
    implements io.helidon.metrics.api.DistributionStatisticsConfig,
    NoOpWrapper {
        private DistributionStatisticsConfig(Builder builder) {
        }

        static Builder builder() {
            return new Builder();
        }

        @Override
        public Optional<Iterable<Double>> percentiles() {
            return Optional.empty();
        }

        @Override
        public Optional<Double> minimumExpectedValue() {
            return Optional.empty();
        }

        @Override
        public Optional<Double> maximumExpectedValue() {
            return Optional.empty();
        }

        @Override
        public Optional<Iterable<Double>> buckets() {
            return Optional.empty();
        }

        static class Builder
        implements DistributionStatisticsConfig.Builder,
        NoOpWrapper {
            Builder() {
            }

            public io.helidon.metrics.api.DistributionStatisticsConfig build() {
                return new DistributionStatisticsConfig(this);
            }

            @Override
            public DistributionStatisticsConfig.Builder minimumExpectedValue(Double min) {
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            @Override
            public DistributionStatisticsConfig.Builder maximumExpectedValue(Double max) {
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            @Override
            public DistributionStatisticsConfig.Builder percentiles(double ... percentiles) {
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            @Override
            public DistributionStatisticsConfig.Builder percentiles(Iterable<Double> percentiles) {
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            @Override
            public DistributionStatisticsConfig.Builder buckets(double ... buckets) {
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            @Override
            public DistributionStatisticsConfig.Builder buckets(Iterable<Double> buckets) {
                return (DistributionStatisticsConfig.Builder)this.identity();
            }

            @Override
            public Optional<Double> minimumExpectedValue() {
                return Optional.empty();
            }

            @Override
            public Optional<Double> maximumExpectedValue() {
                return Optional.empty();
            }

            @Override
            public Iterable<Double> percentiles() {
                return Set.of();
            }

            @Override
            public Iterable<Double> buckets() {
                return Set.of();
            }
        }
    }

    static class Timer
    extends NoOpMeter
    implements io.helidon.metrics.api.Timer {
        private Timer(Builder builder) {
            super(builder);
        }

        static Sample start() {
            return new Sample();
        }

        static Sample start(MeterRegistry meterRegistry) {
            return new Sample();
        }

        static Sample start(Clock clock) {
            return new Sample();
        }

        static Builder builder(String name) {
            return new Builder(name);
        }

        @Override
        public io.helidon.metrics.api.HistogramSnapshot snapshot() {
            return null;
        }

        @Override
        public void record(long amount, TimeUnit unit) {
        }

        @Override
        public void record(Duration duration) {
        }

        @Override
        public <T> T record(Supplier<T> f) {
            return null;
        }

        @Override
        public <T> T record(Callable<T> f) throws Exception {
            return f.call();
        }

        @Override
        public void record(Runnable f) {
            f.run();
        }

        @Override
        public Runnable wrap(Runnable f) {
            return f;
        }

        @Override
        public <T> Callable<T> wrap(Callable<T> f) {
            return f;
        }

        @Override
        public <T> Supplier<T> wrap(Supplier<T> f) {
            return null;
        }

        @Override
        public long count() {
            return 0L;
        }

        @Override
        public double totalTime(TimeUnit unit) {
            return 0.0;
        }

        @Override
        public double mean(TimeUnit unit) {
            return 0.0;
        }

        @Override
        public double max(TimeUnit unit) {
            return 0.0;
        }

        static class Sample
        implements Timer.Sample {
            private Sample() {
            }

            @Override
            public long stop(io.helidon.metrics.api.Timer timer) {
                return 0L;
            }
        }

        static class Builder
        extends io.helidon.metrics.api.NoOpMeter$Builder<Builder, Timer>
        implements Timer.Builder {
            private double[] percentiles;
            private Duration[] buckets;
            private Duration min;
            private Duration max;
            private Boolean publishPercentileHistogram;

            private Builder(String name) {
                super(name, Meter.Type.TIMER);
            }

            @Override
            public Timer build() {
                return new Timer(this);
            }

            @Override
            public Builder percentiles(double ... percentiles) {
                this.percentiles = percentiles;
                return (Builder)this.identity();
            }

            @Override
            public Builder buckets(Duration ... buckets) {
                this.buckets = buckets;
                return (Builder)this.identity();
            }

            @Override
            public Builder minimumExpectedValue(Duration min) {
                this.min = min;
                return (Builder)this.identity();
            }

            @Override
            public Builder maximumExpectedValue(Duration max) {
                this.max = max;
                return (Builder)this.identity();
            }

            @Override
            public Timer.Builder publishPercentileHistogram(boolean value) {
                this.publishPercentileHistogram = value;
                return (Timer.Builder)this.identity();
            }

            @Override
            public Iterable<Double> percentiles() {
                return Arrays.stream(this.percentiles).boxed().toList();
            }

            @Override
            public Iterable<Duration> buckets() {
                return List.of(this.buckets);
            }

            @Override
            public Optional<Duration> minimumExpectedValue() {
                return Optional.ofNullable(this.min);
            }

            @Override
            public Optional<Duration> maximumExpectedValue() {
                return Optional.ofNullable(this.max);
            }

            @Override
            public Optional<Boolean> publishPercentileHistogram() {
                return Optional.ofNullable(this.publishPercentileHistogram);
            }
        }
    }

    static abstract class Gauge<N extends Number>
    extends NoOpMeter
    implements io.helidon.metrics.api.Gauge<N> {
        protected Gauge(Builder<?, N> builder) {
            super(builder);
        }

        static <T> Builder.DoubleFunctionBased<T> builder(String name, T stateObject, ToDoubleFunction<T> fn) {
            return new Builder.DoubleFunctionBased<T>(name, stateObject, fn);
        }

        static <N extends Number> Builder.SupplierBased<N> builder(String name, Supplier<N> supplier) {
            return new Builder.SupplierBased<N>(name, supplier);
        }

        static abstract class Builder<B extends Builder<B, N>, N extends Number>
        extends io.helidon.metrics.api.NoOpMeter$Builder<B, Gauge<N>>
        implements Gauge.Builder<N> {
            protected Builder(String name) {
                super(name, Meter.Type.GAUGE);
            }

            static class SupplierBased<N extends Number>
            extends Builder<SupplierBased<N>, N> {
                private final Supplier<N> supplier;

                private SupplierBased(String name, Supplier<N> supplier) {
                    super(name);
                    this.supplier = supplier;
                }

                @Override
                Gauge<N> build() {
                    return new Gauge<N>(this){

                        @Override
                        public N value() {
                            return (Number)supplier.get();
                        }
                    };
                }

                @Override
                public Supplier<N> supplier() {
                    return this.supplier;
                }
            }

            static class DoubleFunctionBased<T>
            extends Builder<DoubleFunctionBased<T>, Double> {
                private final T stateObject;
                private final ToDoubleFunction<T> fn;

                private DoubleFunctionBased(String name, T stateObject, ToDoubleFunction<T> fn) {
                    super(name);
                    this.stateObject = stateObject;
                    this.fn = fn;
                }

                @Override
                Gauge<Double> build() {
                    return new Gauge<Double>((Builder)this){

                        @Override
                        public Double value() {
                            return fn.applyAsDouble(stateObject);
                        }
                    };
                }

                @Override
                public Supplier<Double> supplier() {
                    return () -> this.fn.applyAsDouble(this.stateObject);
                }
            }
        }
    }

    static class HistogramSnapshot
    implements io.helidon.metrics.api.HistogramSnapshot,
    NoOpWrapper {
        private final long count;
        private final double total;
        private final double max;

        private HistogramSnapshot(long count, double total, double max) {
            this.count = count;
            this.total = total;
            this.max = max;
        }

        static HistogramSnapshot empty(long count, double total, double max) {
            return new HistogramSnapshot(count, total, max);
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public double total() {
            return this.total;
        }

        @Override
        public double total(TimeUnit timeUnit) {
            return timeUnit.convert((long)this.total, TimeUnit.NANOSECONDS);
        }

        @Override
        public double max() {
            return this.max;
        }

        @Override
        public double mean() {
            return this.total / (double)this.count;
        }

        @Override
        public double mean(TimeUnit timeUnit) {
            return timeUnit.convert((long)this.mean(), TimeUnit.NANOSECONDS);
        }

        public Iterable<ValueAtPercentile> percentileValues() {
            return Set.of();
        }

        @Override
        public Iterable<Bucket> histogramCounts() {
            return Set.of();
        }

        @Override
        public void outputSummary(PrintStream out, double scale) {
        }
    }

    static class DistributionSummary
    extends NoOpMeter
    implements io.helidon.metrics.api.DistributionSummary {
        private DistributionSummary(Builder builder) {
            super(builder);
        }

        static Builder builder(String name) {
            return new Builder(name);
        }

        @Override
        public void record(double amount) {
        }

        @Override
        public long count() {
            return 0L;
        }

        @Override
        public double totalAmount() {
            return 0.0;
        }

        @Override
        public double mean() {
            return 0.0;
        }

        @Override
        public double max() {
            return 0.0;
        }

        @Override
        public io.helidon.metrics.api.HistogramSnapshot snapshot() {
            return new HistogramSnapshot(0L, 0.0, 0.0);
        }

        static class Builder
        extends io.helidon.metrics.api.NoOpMeter$Builder<Builder, DistributionSummary>
        implements DistributionSummary.Builder {
            private static final double DEFAULT_SCALE = 1.0;
            private DistributionStatisticsConfig.Builder distributionStatisticsConfigBuilder;
            private Double scale;
            private boolean publishPercentileHistogram;

            private Builder(String name) {
                super(name, Meter.Type.DISTRIBUTION_SUMMARY);
            }

            @Override
            public DistributionSummary build() {
                return new DistributionSummary(this);
            }

            @Override
            public Builder scale(double scale) {
                this.scale = scale;
                return (Builder)this.identity();
            }

            @Override
            public Builder distributionStatisticsConfig(DistributionStatisticsConfig.Builder distributionStatisticsConfigBuilder) {
                this.distributionStatisticsConfigBuilder = distributionStatisticsConfigBuilder;
                return (Builder)this.identity();
            }

            @Override
            public DistributionSummary.Builder publishPercentileHistogram(boolean value) {
                this.publishPercentileHistogram = value;
                return (DistributionSummary.Builder)this.identity();
            }

            @Override
            public Optional<Double> scale() {
                return Optional.ofNullable(this.scale);
            }

            @Override
            public Optional<DistributionStatisticsConfig.Builder> distributionStatisticsConfig() {
                return Optional.ofNullable(this.distributionStatisticsConfigBuilder);
            }

            @Override
            public Optional<Boolean> publishPercentileHistogram() {
                return Optional.ofNullable(this.publishPercentileHistogram);
            }
        }
    }

    static class FunctionalCounter
    extends NoOpMeter
    implements io.helidon.metrics.api.FunctionalCounter {
        private FunctionalCounter(Builder<?> builder) {
            super(builder);
        }

        static <T> Builder<T> builder(String name, T target, Function<T, Long> fn) {
            return new Builder<T>(name, target, fn);
        }

        @Override
        public long count() {
            return 0L;
        }

        static class Builder<T>
        extends io.helidon.metrics.api.NoOpMeter$Builder<Builder<T>, FunctionalCounter>
        implements FunctionalCounter.Builder<T> {
            private final T stateObject;
            private final Function<T, Long> fn;

            private Builder(String name, T stateObject, Function<T, Long> fn) {
                super(name, Meter.Type.COUNTER);
                this.stateObject = stateObject;
                this.fn = fn;
            }

            @Override
            public T stateObject() {
                return this.stateObject;
            }

            @Override
            public Function<T, Long> fn() {
                return this.fn;
            }

            @Override
            public FunctionalCounter build() {
                return new FunctionalCounter(this);
            }
        }
    }

    static class Counter
    extends NoOpMeter
    implements io.helidon.metrics.api.Counter {
        protected Counter(Builder builder) {
            super(builder);
        }

        static Counter create(String name, Iterable<Tag> tags) {
            return ((Builder)Counter.builder(name).tags(tags)).build();
        }

        static Builder builder(String name) {
            return new Builder(name);
        }

        @Override
        public void increment() {
        }

        @Override
        public void increment(long amount) {
        }

        @Override
        public long count() {
            return 0L;
        }

        static class Builder
        extends io.helidon.metrics.api.NoOpMeter$Builder<Builder, Counter>
        implements Counter.Builder {
            protected Builder(String name) {
                super(name, Meter.Type.COUNTER);
            }

            @Override
            public Counter build() {
                return new Counter(this);
            }
        }
    }
}

