/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.metrics.api.MeterRegistryFormatter;
import io.helidon.metrics.api.Metrics;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class MicrometerPrometheusFormatter
implements MeterRegistryFormatter {
    public static final Map<MediaType, String> MEDIA_TYPE_TO_FORMAT = Map.of(MediaTypes.TEXT_PLAIN, "text/plain; version=0.0.4; charset=utf-8", MediaTypes.APPLICATION_OPENMETRICS_TEXT, "application/openmetrics-text; version=1.0.0; charset=utf-8");
    private final String scopeTagName;
    private final Iterable<String> scopeSelection;
    private final Iterable<String> meterNameSelection;
    private final MediaType resultMediaType;
    private final io.helidon.metrics.api.MeterRegistry meterRegistry;

    private MicrometerPrometheusFormatter(Builder builder) {
        this.scopeTagName = builder.scopeTagName;
        this.scopeSelection = builder.scopeSelection;
        this.meterNameSelection = builder.meterNameSelection;
        this.resultMediaType = builder.resultMediaType;
        this.meterRegistry = Objects.requireNonNullElseGet(builder.meterRegistry, Metrics::globalRegistry);
    }

    public static Builder builder(io.helidon.metrics.api.MeterRegistry meterRegistry) {
        return new Builder(meterRegistry);
    }

    public static String normalizeNameToPrometheus(String name) {
        Object result = name;
        if (((String)(result = ((String)result).replaceAll("[-+.!?@#$%^&*`'\\s]+", "_"))).matches("^[0-9_]+.*")) {
            result = "m_" + (String)result;
        }
        result = ((String)result).replaceAll("[^A-Za-z0-9_:]", "_");
        return result;
    }

    static Set<String> meterNameSuffixes(Meter.Type meterType) {
        return switch (meterType) {
            default -> throw new MatchException(null, null);
            case Meter.Type.COUNTER -> Set.of("_total");
            case Meter.Type.DISTRIBUTION_SUMMARY, Meter.Type.LONG_TASK_TIMER, Meter.Type.TIMER -> Set.of("_count", "_sum", "_max", "_bucket");
            case Meter.Type.GAUGE, Meter.Type.OTHER -> Set.of();
        };
    }

    public Optional<Object> format() {
        Optional<PrometheusMeterRegistry> prometheusMeterRegistry = MicrometerPrometheusFormatter.prometheusMeterRegistry(this.meterRegistry);
        if (prometheusMeterRegistry.isPresent()) {
            Set<String> meterNamesOfInterest = this.meterNamesOfInterest(prometheusMeterRegistry.get(), this.scopeSelection, this.meterNameSelection);
            if (meterNamesOfInterest.isEmpty()) {
                return Optional.empty();
            }
            String prometheusOutput = prometheusMeterRegistry.get().scrape(MEDIA_TYPE_TO_FORMAT.get(this.resultMediaType), meterNamesOfInterest);
            return prometheusOutput.isBlank() ? Optional.empty() : Optional.of(prometheusOutput);
        }
        return Optional.empty();
    }

    public Optional<Object> formatMetadata() {
        return Optional.empty();
    }

    Set<String> meterNamesOfInterest(PrometheusMeterRegistry prometheusMeterRegistry, Iterable<String> scopeSelection, Iterable<String> meterNameSelection) {
        HashSet<String> result = new HashSet<String>();
        HashSet scopes = new HashSet();
        scopeSelection.forEach(scopes::add);
        HashSet names = new HashSet();
        meterNameSelection.forEach(names::add);
        Predicate<Meter> scopePredicate = scopes.isEmpty() || this.scopeTagName == null || this.scopeTagName.isBlank() ? m -> true : m -> scopes.contains(m.getId().getTag(this.scopeTagName));
        Predicate<String> namePredicate = names.isEmpty() ? n -> true : names::contains;
        for (Meter meter : prometheusMeterRegistry.getMeters()) {
            String meterName = meter.getId().getName();
            if (!namePredicate.test(meterName) || !scopePredicate.test(meter)) continue;
            HashSet<String> allUnitsForMeterName = new HashSet<String>();
            allUnitsForMeterName.add("");
            HashSet<String> allSuffixesForMeterName = new HashSet<String>();
            allSuffixesForMeterName.add("");
            prometheusMeterRegistry.find(meterName).meters().forEach(m -> {
                Meter.Id meterId = m.getId();
                String normalizedUnit = MicrometerPrometheusFormatter.normalizeUnit(meterId.getBaseUnit());
                if (!normalizedUnit.isBlank()) {
                    allUnitsForMeterName.add("_" + normalizedUnit);
                }
                allSuffixesForMeterName.addAll(MicrometerPrometheusFormatter.meterNameSuffixes(meterId.getType()));
            });
            String normalizedMeterName = MicrometerPrometheusFormatter.normalizeNameToPrometheus(meterName);
            allUnitsForMeterName.forEach(units -> allSuffixesForMeterName.forEach(suffix -> result.add(normalizedMeterName + units + suffix)));
        }
        return result;
    }

    private static Optional<PrometheusMeterRegistry> prometheusMeterRegistry(io.helidon.metrics.api.MeterRegistry meterRegistry) {
        MeterRegistry mMeterRegistry = (MeterRegistry)meterRegistry.unwrap(MeterRegistry.class);
        if (mMeterRegistry instanceof CompositeMeterRegistry) {
            CompositeMeterRegistry compositeMeterRegistry = (CompositeMeterRegistry)mMeterRegistry;
            return compositeMeterRegistry.getRegistries().stream().filter(PrometheusMeterRegistry.class::isInstance).findFirst().map(PrometheusMeterRegistry.class::cast);
        }
        return Optional.empty();
    }

    private static String flushForMeterAndClear(StringBuilder helpAndType, StringBuilder metricData) {
        StringBuilder result = new StringBuilder();
        if (!metricData.isEmpty()) {
            result.append(helpAndType.toString()).append((CharSequence)metricData);
        }
        helpAndType.setLength(0);
        metricData.setLength(0);
        return result.toString();
    }

    private static String normalizeUnit(String unit) {
        return unit == null ? "" : unit;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, MicrometerPrometheusFormatter> {
        private Iterable<String> meterNameSelection = Set.of();
        private String scopeTagName;
        private Iterable<String> scopeSelection = Set.of();
        private MediaType resultMediaType = MediaTypes.TEXT_PLAIN;
        private io.helidon.metrics.api.MeterRegistry meterRegistry;

        private Builder() {
        }

        private Builder(io.helidon.metrics.api.MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
        }

        public MicrometerPrometheusFormatter build() {
            return new MicrometerPrometheusFormatter(this);
        }

        public Builder meterNameSelection(Iterable<String> meterNameSelection) {
            this.meterNameSelection = meterNameSelection;
            return (Builder)this.identity();
        }

        public Builder scopeSelection(Iterable<String> scopeSelection) {
            this.scopeSelection = scopeSelection;
            return (Builder)this.identity();
        }

        public Builder scopeTagName(String scopeTagName) {
            this.scopeTagName = scopeTagName;
            return (Builder)this.identity();
        }

        public Builder resultMediaType(MediaType resultMediaType) {
            this.resultMediaType = resultMediaType;
            return (Builder)this.identity();
        }
    }
}

