/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.microprofile.cdi.ContainerInstanceHolder;
import io.helidon.microprofile.cdi.HelidonContainer;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.spi.CDI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Main {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final AtomicBoolean MAIN_CALLED = new AtomicBoolean();
    private static final HelidonContainer CONTAINER = ContainerInstanceHolder.get();
    private static volatile HelidonContainer inUse;

    private Main() {
    }

    public static void main(String[] args) {
        inUse = ContainerInstanceHolder.isReset() ? ContainerInstanceHolder.get() : CONTAINER;
        inUse.start();
        MAIN_CALLED.set(true);
    }

    public static void shutdown() {
        if (null != inUse && MAIN_CALLED.get()) {
            LOGGER.finest("Shutting down container from cdi.Main");
            MAIN_CALLED.set(false);
            inUse.shutdown();
        } else {
            try {
                ((SeContainer)CDI.current()).close();
            }
            catch (IllegalStateException e) {
                LOGGER.log(Level.FINEST, "Failed to obtain a CDI instance to shut down, probably duplicate call", e);
            }
        }
    }
}

