/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class AnnotationFinder {
    private static final String[] SKIP_PACKAGE_PREFIXES = new String[]{"java.", "javax.", "jakarta.", "org.eclipse.microprofile."};
    private final Package pkg;

    private AnnotationFinder(Package pkg) {
        this.pkg = pkg;
    }

    static AnnotationFinder create(Package pkg) {
        Objects.requireNonNull(pkg);
        return new AnnotationFinder(pkg);
    }

    Set<Annotation> findAnnotations(Set<Annotation> set, BeanManager bm) {
        return this.findAnnotations(set, new HashSet<Annotation>(), new HashSet<Annotation>(), this.pkg, bm);
    }

    private Set<Annotation> findAnnotations(Set<Annotation> set, Set<Annotation> result, Set<Annotation> seen, Package pkg, BeanManager bm) {
        for (Annotation a1 : set) {
            Class<? extends Annotation> a1Type = a1.annotationType();
            if (a1Type.getName().startsWith(pkg.getName())) {
                result.add(a1);
                continue;
            }
            if (seen.contains(a1) || !this.isOfInterest(a1, bm)) continue;
            seen.add(a1);
            Set<Annotation> a1Set = Set.of(a1Type.getAnnotations());
            this.findAnnotations(a1Set, result, seen, pkg, bm);
        }
        return result;
    }

    private boolean isOfInterest(Annotation a, BeanManager bm) {
        if (bm != null && bm.isInterceptorBinding(a.annotationType()) || a.annotationType().isAnnotationPresent(InterceptorBinding.class)) {
            Optional<String> matches = Stream.of(SKIP_PACKAGE_PREFIXES).filter(pp -> a.annotationType().getPackage().getName().startsWith((String)pp)).findAny();
            return matches.isEmpty();
        }
        return false;
    }
}

