/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.microprofile.faulttolerance.FtSupplier;
import java.util.concurrent.CancellationException;

class CancellableFtSupplier<T>
implements FtSupplier<T> {
    private boolean cancelled = false;
    private boolean getCalled = false;
    private final FtSupplier<T> supplier;

    private CancellableFtSupplier(FtSupplier<T> supplier) {
        this.supplier = supplier;
    }

    void cancel() {
        this.cancelled = true;
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    boolean getCalled() {
        return this.getCalled;
    }

    @Override
    public T get() throws Throwable {
        this.getCalled = true;
        if (this.cancelled) {
            throw new CancellationException("Supplier has been cancelled");
        }
        return this.supplier.get();
    }

    static <T> CancellableFtSupplier<T> create(FtSupplier<T> supplier) {
        return new CancellableFtSupplier<T>(supplier);
    }
}

