/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.microprofile.jwt.auth.Impl;
import io.helidon.microprofile.jwt.auth.JsonWebTokenImpl;
import io.helidon.security.Principal;
import io.helidon.security.SecurityContext;
import io.helidon.security.Subject;
import io.helidon.security.jwt.SignedJwt;
import io.helidon.security.providers.common.TokenCredential;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
class JsonWebTokenProducer {
    @Inject
    private SecurityContext securityContext;

    JsonWebTokenProducer() {
    }

    @Produces
    @RequestScoped
    public JsonWebToken produceToken() {
        return this.securityContext.user().map(this::toJsonWebToken).orElseGet(JsonWebTokenImpl::empty);
    }

    private JsonWebTokenImpl toJsonWebToken(Subject subject) {
        Principal principal = subject.principal();
        if (principal instanceof JsonWebTokenImpl) {
            return (JsonWebTokenImpl)principal;
        }
        return subject.publicCredential(TokenCredential.class).flatMap(it -> it.getTokenInstance(SignedJwt.class)).map(JsonWebTokenImpl::create).orElseGet(JsonWebTokenImpl::empty);
    }

    @Produces
    @Impl
    @RequestScoped
    public JsonWebTokenImpl produceTokenImpl() {
        return (JsonWebTokenImpl)this.produceToken();
    }
}

