/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.jwt.auth;

import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.jwt.auth.ClaimProducer;
import io.helidon.microprofile.jwt.auth.JsonWebTokenProducer;
import io.helidon.microprofile.jwt.auth.JwtAuthProvider;
import io.helidon.microprofile.security.SecurityCdiExtension;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.security.spi.SecurityProvider;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.enterprise.util.Nonbinding;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.auth.LoginConfig;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;

public class JwtAuthCdiExtension
implements Extension {
    private static final Set<Class<?>> CUSTOM_CLAIM_ALLOWED_TYPES = Set.of(Long.class, Long.TYPE, String.class, Boolean.class, Boolean.TYPE);
    private final List<ClaimIP> qualifiers = new LinkedList<ClaimIP>();
    private final List<ClaimIP> claimValueQualifiers = new LinkedList<ClaimIP>();
    private Config config;

    void before(@Observes BeforeBeanDiscovery discovery) {
        discovery.addAnnotatedType(JsonWebTokenProducer.class, "TokenProducer");
    }

    void collectClaimProducer(@Observes ProcessInjectionPoint<?, ?> pip) {
        Claim claim = (Claim)pip.getInjectionPoint().getAnnotated().getAnnotation(Claim.class);
        if (claim != null) {
            if (claim.standard() != Claims.UNKNOWN && !claim.value().isEmpty()) {
                throw new DeploymentException("Claim annotation should not have both values at value and standard! @Claim(value=" + claim.value() + ", standard=Claims." + claim.standard().name() + ")");
            }
            InjectionPoint ip = pip.getInjectionPoint();
            Type type = ip.getType();
            FieldTypes ft = FieldTypes.forType(type);
            ClaimLiteral q = new ClaimLiteral(claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name(), ip.getMember().getDeclaringClass().getName() + "." + this.getFieldName(ip), ft.isOptional(), ft.isClaimValue(), ft.getField0().getRawType(), ft.getField1().getRawType(), ft.getField2().getRawType(), ft.getField3().getRawType(), type.toString());
            pip.configureInjectionPoint().addQualifier((Annotation)q);
            if (ft.getField0().getRawType().equals(ClaimValue.class)) {
                this.claimValueQualifiers.add(new ClaimIP(q, type));
            } else {
                this.qualifiers.add(new ClaimIP(q, type));
            }
        }
    }

    void registerClaimProducers(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        this.qualifiers.forEach(q -> abd.addBean((Bean)new ClaimProducer(q.qualifier, q.type, Dependent.class)));
        this.claimValueQualifiers.forEach(q -> abd.addBean((Bean)new ClaimProducer(q.qualifier, q.type, RequestScoped.class)));
    }

    void validate(@Observes AfterDeploymentValidation add) {
        this.qualifiers.forEach(q -> {
            ClaimLiteral claimLiteral = q.getQualifier();
            this.validate(claimLiteral);
        });
    }

    void configured(@Observes @RuntimeStart Config config) {
        this.config = config;
    }

    void registerProvider(@Observes @Initialized(value=ApplicationScoped.class) @Priority(value=5) Object event, BeanManager bm) {
        SecurityCdiExtension security = (SecurityCdiExtension)bm.getExtension(SecurityCdiExtension.class);
        if (security.securityBuilder().hasProvider("mp-jwt-auth")) {
            return;
        }
        JaxRsCdiExtension jaxrs = (JaxRsCdiExtension)bm.getExtension(JaxRsCdiExtension.class);
        boolean notNeeded = jaxrs.applicationsToRun().stream().map(JaxRsApplication::applicationClass).flatMap(Optional::stream).map(clazz -> clazz.getAnnotation(LoginConfig.class)).filter(Objects::nonNull).map(LoginConfig::authMethod).noneMatch("MP-JWT"::equals);
        if (notNeeded) {
            return;
        }
        security.securityBuilder().addProvider((SecurityProvider)JwtAuthProvider.create((io.helidon.common.config.Config)this.config), "mp-jwt-auth");
    }

    private String getFieldName(InjectionPoint ip) {
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedField) {
            AnnotatedField f = (AnnotatedField)annotated;
            return f.getJavaMember().getName();
        }
        if (annotated instanceof AnnotatedParameter) {
            AnnotatedParameter p = (AnnotatedParameter)annotated;
            Member member = ip.getMember();
            if (member instanceof Method) {
                return member.getName() + "_" + p.getPosition();
            }
            if (member instanceof Constructor) {
                return "new_" + p.getPosition();
            }
        }
        return ip.getMember().getName();
    }

    private void validate(ClaimLiteral claimLiteral) {
        Class<?> rawType = claimLiteral.rawType();
        if (ClaimValue.class.equals(rawType)) {
            this.validateClaimValue(claimLiteral, claimLiteral.typeArg(), claimLiteral.typeArg2(), claimLiteral.typeArg3());
        } else if (Optional.class.equals(rawType)) {
            this.validateOptional(claimLiteral, claimLiteral.typeArg(), claimLiteral.typeArg2());
        } else if (Set.class.equals(rawType) || JsonArray.class.equals(rawType)) {
            this.validateSet(claimLiteral, rawType, claimLiteral.typeArg());
        } else {
            this.validateBaseType(claimLiteral, rawType);
        }
    }

    private void validateClaimValue(ClaimLiteral claimLiteral, Class<?> parameter, Class<?> parameter2, Class<?> parameter3) {
        if (ClaimValue.class.equals(parameter)) {
            throw new DeploymentException("ClaimValue has to be used as top level wrapper type. It cannot be parameter as it is in the field " + claimLiteral.id + " of type " + claimLiteral.fieldTypeString);
        }
        if (Optional.class.equals(parameter)) {
            this.validateOptional(claimLiteral, parameter2, parameter3);
        } else if (Set.class.equals(parameter) || JsonArray.class.equals(parameter)) {
            this.validateSet(claimLiteral, parameter, parameter2);
        } else {
            this.validateBaseType(claimLiteral, parameter);
        }
    }

    private void validateOptional(ClaimLiteral claimLiteral, Class<?> parameter, Class<?> parameter2) {
        if (ClaimValue.class.equals(parameter)) {
            throw new DeploymentException("ClaimValue has to be used as top level wrapper type. It cannot be parameter of Optional as it is in the field " + claimLiteral.id + " of type " + claimLiteral.fieldTypeString);
        }
        if (Optional.class.equals(parameter)) {
            throw new DeploymentException("Optional has to be used as top/second level wrapper type. It cannot be parameter of another Optional as it is in the field " + claimLiteral.id + " of type " + claimLiteral.fieldTypeString);
        }
        if (Set.class.equals(parameter) || JsonArray.class.equals(parameter)) {
            this.validateSet(claimLiteral, parameter, parameter2);
        } else {
            this.validateBaseType(claimLiteral, parameter);
        }
    }

    private void validateSet(ClaimLiteral claimLiteral, Class<?> parent, Class<?> parameter) {
        block4: {
            if (!String.class.equals(parameter) && !NoType.class.equals(parameter)) {
                throw new DeploymentException("Set<" + parameter.getName() + "> is not supported type. Field has to have a Set with a String parameter.");
            }
            try {
                Claims claims = Claims.valueOf((String)claimLiteral.name);
                if (!Set.class.isAssignableFrom(claims.getType()) && !JsonArray.class.isAssignableFrom(claims.getType())) {
                    throw new DeploymentException("Cannot assign value of claim " + claimLiteral.name + " (claim type: " + claims.getType().getName() + ")  to the field " + claimLiteral.id + " of type " + claimLiteral.fieldTypeString);
                }
            }
            catch (IllegalArgumentException ignored) {
                if (JsonArray.class.equals(parent)) break block4;
                throw new DeploymentException("Field type has to be JsonArray (instead of Set<String>) while using custom claim name. Field " + claimLiteral.id + " can not be type: " + claimLiteral.fieldTypeString);
            }
        }
    }

    private void validateBaseType(ClaimLiteral claimLiteral, Class<?> clazz) {
        if (NoType.class.equals(clazz)) {
            return;
        }
        try {
            Claims claims = Claims.valueOf((String)claimLiteral.name);
            if ((clazz.equals(Long.class) || clazz.equals(Long.TYPE) || JsonNumber.class.isAssignableFrom(clazz)) && (Long.class.equals((Object)claims.getType()) || JsonNumber.class.isAssignableFrom(claims.getType()))) {
                return;
            }
            if ((clazz.equals(String.class) || JsonString.class.isAssignableFrom(clazz)) && (String.class.equals((Object)claims.getType()) || JsonString.class.isAssignableFrom(claims.getType()))) {
                return;
            }
            if ((clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) || JsonValue.class.isAssignableFrom(clazz)) && (Boolean.class.equals((Object)claims.getType()) || JsonValue.class.isAssignableFrom(claims.getType()))) {
                return;
            }
            if (clazz.equals(JsonObject.class) && JsonObject.class.isAssignableFrom(claims.getType())) {
                return;
            }
            if (clazz.equals(JsonArray.class) && Set.class.isAssignableFrom(claims.getType())) {
                return;
            }
            throw new DeploymentException("Cannot assign value of claim " + claimLiteral.name + " (claim type: " + claims.getType().getName() + ")  to the field " + claimLiteral.id + " of type " + claimLiteral.fieldTypeString);
        }
        catch (IllegalArgumentException ignored) {
            if (CUSTOM_CLAIM_ALLOWED_TYPES.contains(clazz) || JsonValue.class.isAssignableFrom(clazz)) {
                return;
            }
            throw new DeploymentException("Field type has to be Long, Boolean, String or JsonValue (or its subtype) while using custom claim name. Field " + claimLiteral.id + " can not be type: " + claimLiteral.fieldTypeString);
        }
    }

    static class FieldTypes {
        private boolean optional = false;
        private boolean claimValue = false;
        private TypedField field0;
        private TypedField field1;
        private TypedField field2;
        private TypedField field3;

        FieldTypes() {
        }

        static FieldTypes forType(Type type) {
            FieldTypes ft = new FieldTypes();
            TypedField firstType = FieldTypes.getTypedField(type);
            ft.field0 = firstType.rawType.equals(Instance.class) || firstType.rawType.equals(Provider.class) ? FieldTypes.getTypedField(firstType) : firstType;
            ft.field1 = FieldTypes.getTypedField(ft.field0);
            ft.field2 = FieldTypes.getTypedField(ft.field1);
            ft.field3 = FieldTypes.getTypedField(ft.field2);
            if (ft.field0.getRawType().equals(ClaimValue.class)) {
                ft.claimValue = true;
            }
            if (ft.field0.getRawType().equals(Optional.class) || ft.field1.getRawType().equals(Optional.class)) {
                ft.optional = true;
            }
            return ft;
        }

        static TypedField getTypedField(Type type) {
            if (type instanceof Class) {
                return new TypedField((Class)type);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                return new TypedField((Class)paramType.getRawType(), paramType);
            }
            throw new UnsupportedOperationException("No idea how to handle " + String.valueOf(type));
        }

        private static TypedField getTypedField(TypedField field) {
            if (field.isParameterized()) {
                ParameterizedType paramType = field.paramType;
                Object[] typeArgs = paramType.getActualTypeArguments();
                if (typeArgs.length == 1) {
                    Type typeArg = typeArgs[0];
                    return FieldTypes.getTypedField(typeArg);
                }
                if (typeArgs.length == 2 && field.rawType.equals(Map.class) && typeArgs[0].equals(typeArgs[1]) && typeArgs[0].equals(String.class)) {
                    return new TypedField(String.class);
                }
                throw new DeploymentException("Cannot create config property for " + String.valueOf(field.rawType) + ", params: " + Arrays.toString(typeArgs));
            }
            return new TypedField(NoType.class);
        }

        TypedField getField0() {
            return this.field0;
        }

        TypedField getField1() {
            return this.field1;
        }

        TypedField getField2() {
            return this.field2;
        }

        TypedField getField3() {
            return this.field3;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isClaimValue() {
            return this.claimValue;
        }

        static final class TypedField {
            private final Class<?> rawType;
            private ParameterizedType paramType;

            private TypedField(Class<?> rawType) {
                this.rawType = rawType;
            }

            private TypedField(Class<?> rawType, ParameterizedType paramType) {
                this.rawType = rawType;
                this.paramType = paramType;
            }

            boolean isParameterized() {
                return this.paramType != null;
            }

            Class<?> getRawType() {
                return this.rawType;
            }

            ParameterizedType getParamType() {
                return this.paramType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || !this.getClass().equals(o.getClass())) {
                    return false;
                }
                TypedField that = (TypedField)o;
                return Objects.equals(this.rawType, that.rawType) && Objects.equals(this.paramType, that.paramType);
            }

            public int hashCode() {
                return Objects.hash(this.rawType, this.paramType);
            }

            public String toString() {
                return "TypedField{rawType=" + String.valueOf(this.rawType) + ", paramType=" + String.valueOf(this.paramType) + "}";
            }
        }
    }

    static class ClaimLiteral
    extends AnnotationLiteral<MpClaimQualifier>
    implements MpClaimQualifier {
        private final String name;
        private final String id;
        private final boolean optional;
        private final boolean claimValue;
        private final Class<?> rawType;
        private final Class<?> typeArg;
        private final Class<?> typeArg2;
        private final Class<?> typeArg3;
        private final String fieldTypeString;

        ClaimLiteral(String name, String id, boolean optional, boolean claimValue, Class<?> rawType, Class<?> typeArg, Class<?> typeArg2, Class<?> typeArg3, String fieldTypeString) {
            this.name = name;
            this.id = id;
            this.optional = optional;
            this.claimValue = claimValue;
            this.rawType = rawType;
            this.typeArg = typeArg;
            this.typeArg2 = typeArg2;
            this.typeArg3 = typeArg3;
            this.fieldTypeString = fieldTypeString;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public boolean optional() {
            return this.optional;
        }

        @Override
        public boolean claimValue() {
            return this.claimValue;
        }

        @Override
        public Class<?> rawType() {
            return this.rawType;
        }

        @Override
        public Class<?> typeArg() {
            return this.typeArg;
        }

        @Override
        public Class<?> typeArg2() {
            return this.typeArg2;
        }

        @Override
        public Class<?> typeArg3() {
            return this.typeArg3;
        }

        @Override
        public String toString() {
            return "ClaimLiteral{rawType=" + String.valueOf(this.rawType) + ", name=" + this.name + ", id=" + this.id + "}";
        }
    }

    static class ClaimIP {
        private final ClaimLiteral qualifier;
        private final Type type;

        ClaimIP(ClaimLiteral qualifier, Type type) {
            this.qualifier = qualifier;
            this.type = type;
        }

        public ClaimLiteral getQualifier() {
            return this.qualifier;
        }

        public Type getType() {
            return this.type;
        }
    }

    private static final class NoType {
        private NoType() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
    static @interface MpClaimQualifier {
        @Nonbinding
        public String name();

        public String id();

        @Nonbinding
        public boolean optional();

        @Nonbinding
        public boolean claimValue();

        @Nonbinding
        public Class<?> rawType();

        @Nonbinding
        public Class<?> typeArg();

        @Nonbinding
        public Class<?> typeArg2();

        @Nonbinding
        public Class<?> typeArg3();
    }
}

