/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.LabeledSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.SnapshotMetric;
import io.helidon.metrics.api.Timer;
import io.helidon.microprofile.metrics.DistributionCustomizations;
import io.helidon.microprofile.metrics.HelidonSnapshot;
import io.helidon.microprofile.metrics.MetricImpl;
import io.helidon.microprofile.metrics.Registry;
import io.helidon.microprofile.metrics.WrappedSnapshot;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

final class HelidonTimer
extends MetricImpl<io.helidon.metrics.api.Timer>
implements Timer,
SnapshotMetric {
    private final io.helidon.metrics.api.Timer delegate;
    private final MeterRegistry meterRegistry;

    private HelidonTimer(MeterRegistry meterRegistry, String type, Metadata metadata, io.helidon.metrics.api.Timer delegate) {
        super(type, metadata);
        this.delegate = delegate;
        this.meterRegistry = meterRegistry;
    }

    static HelidonTimer create(MeterRegistry meterRegistry, String scope, Metadata metadata, Tag ... tags) {
        return HelidonTimer.create(meterRegistry, scope, metadata, (io.helidon.metrics.api.Timer)meterRegistry.getOrCreate((Meter.Builder)DistributionCustomizations.apply((Timer.Builder)((Timer.Builder)((Timer.Builder)io.helidon.metrics.api.Timer.builder((String)metadata.getName()).description(metadata.getDescription())).baseUnit(HelidonTimer.sanitizeUnit(metadata.getUnit()))).tags(HelidonTimer.allTags(scope, tags)))));
    }

    static HelidonTimer create(MeterRegistry meterRegistry, String scope, Metadata metadata, io.helidon.metrics.api.Timer delegate) {
        return new HelidonTimer(meterRegistry, scope, metadata, delegate);
    }

    static HelidonTimer create(MeterRegistry meterRegistry, io.helidon.metrics.api.Timer delegate) {
        return new HelidonTimer(meterRegistry, HelidonTimer.resolvedScope((Meter)delegate), Registry.metadata((Meter)delegate), delegate);
    }

    public void update(Duration duration) {
        this.delegate.record(duration);
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos((long)this.delegate.totalTime(TimeUnit.NANOSECONDS));
    }

    public <T> T time(Callable<T> event) throws Exception {
        return (T)this.delegate.record(event);
    }

    public void time(Runnable event) {
        this.delegate.record(event);
    }

    public Timer.Context time() {
        return new ContextImpl(io.helidon.metrics.api.Timer.start((MeterRegistry)this.meterRegistry));
    }

    public long getCount() {
        return this.delegate.count();
    }

    public Snapshot getSnapshot() {
        return HelidonSnapshot.create(this.delegate.snapshot());
    }

    public LabeledSnapshot snapshot() {
        return WrappedSnapshot.create(this.getSnapshot());
    }

    @Override
    public io.helidon.metrics.api.Timer delegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonTimer that = (HelidonTimer)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    protected String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(", count='").append(this.getCount()).append('\'');
        sb.append(", elapsedTime='").append(this.getElapsedTime()).append('\'');
        return sb.toString();
    }

    @Override
    public Class<io.helidon.metrics.api.Timer> delegateType() {
        return io.helidon.metrics.api.Timer.class;
    }

    private final class ContextImpl
    implements Timer.Context {
        private final Timer.Sample delegate;

        private ContextImpl(Timer.Sample delegate) {
            this.delegate = delegate;
        }

        public long stop() {
            return this.delegate.stop(HelidonTimer.this.delegate);
        }

        public void close() {
            this.stop();
        }
    }
}

