/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.microprofile.metrics.HelidonCounter;
import io.helidon.microprofile.metrics.HelidonGauge;
import io.helidon.microprofile.metrics.HelidonHistogram;
import io.helidon.microprofile.metrics.HelidonTimer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

class MetricFactory {
    private final MeterRegistry meterRegistry;

    static MetricFactory create() {
        return new MetricFactory(Metrics.globalRegistry());
    }

    static MetricFactory create(MeterRegistry meterRegistry) {
        return new MetricFactory(meterRegistry);
    }

    MetricFactory(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    Counter counter(String scope, Metadata metadata, Tag ... tags) {
        return HelidonCounter.create(this.meterRegistry, scope, metadata, tags);
    }

    Timer timer(String scope, Metadata metadata, Tag ... tags) {
        return HelidonTimer.create(this.meterRegistry, scope, metadata, tags);
    }

    Histogram summary(String scope, Metadata metadata, Tag ... tags) {
        return HelidonHistogram.create(this.meterRegistry, scope, metadata, tags);
    }

    <N extends Number> Gauge<N> gauge(String scope, Metadata metadata, Supplier<N> supplier, Tag ... tags) {
        return HelidonGauge.create(this.meterRegistry, scope, metadata, supplier, tags);
    }

    <T> Gauge<Double> gauge(String scope, Metadata metadata, T stateObject, ToDoubleFunction<T> fn, Tag ... tags) {
        return HelidonGauge.create(this.meterRegistry, scope, metadata, stateObject, fn, tags);
    }
}

