/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.servicecommon;

import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.webserver.http.HttpRouting;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;

public abstract class HelidonRestCdiExtension
implements Extension {
    private final Map<Bean<?>, AnnotatedMember<?>> producers = new HashMap();
    private final Set<Class<?>> annotatedClasses = new HashSet();
    private final Set<Class<?>> annotatedClassesProcessed = new HashSet();
    private final System.Logger logger;
    private final String[] configPrefixes;
    private volatile Config rootConfig;
    private volatile Config componentConfig;

    protected HelidonRestCdiExtension(System.Logger logger, String ... configPrefixes) {
        this.logger = logger;
        this.configPrefixes = configPrefixes;
    }

    public void clearAnnotationInfo(@Observes AfterDeploymentValidation adv) {
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            HashSet annotatedClassesIgnored = new HashSet(this.annotatedClasses);
            annotatedClassesIgnored.removeAll(this.annotatedClassesProcessed);
            if (!annotatedClassesIgnored.isEmpty()) {
                this.logger.log(System.Logger.Level.DEBUG, () -> "Classes originally found with selected annotations that were not processed, probably because they were vetoed:" + annotatedClassesIgnored.toString());
            }
        }
        this.annotatedClasses.clear();
        this.annotatedClassesProcessed.clear();
    }

    public void observeManagedBeans(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        if (!this.annotatedClasses.contains(clazz)) {
            return;
        }
        this.annotatedClassesProcessed.add(clazz);
        this.logger.log(System.Logger.Level.DEBUG, () -> "Processing managed bean " + clazz.getName());
        this.processManagedBean(pmb);
    }

    protected void processManagedBean(ProcessManagedBean<?> processManagedBean) {
    }

    protected boolean isConcreteNonInterceptor(ProcessAnnotatedType<?> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class clazz = annotatedType.getJavaClass();
        if (annotatedType.isAnnotationPresent(Interceptor.class) || Modifier.isAbstract(clazz.getModifiers())) {
            this.logger.log(System.Logger.Level.TRACE, () -> "Ignoring " + clazz.getName() + " with annotations " + String.valueOf(annotatedType.getAnnotations()) + " for later processing: " + (Modifier.isAbstract(clazz.getModifiers()) ? "abstract " : "") + (annotatedType.isAnnotationPresent(Interceptor.class) ? "interceptor " : ""));
            return false;
        }
        this.logger.log(System.Logger.Level.DEBUG, () -> "Accepting " + clazz.getName() + " for later bean processing");
        return true;
    }

    protected void recordAnnotatedType(ProcessAnnotatedType<?> pat) {
        this.annotatedClasses.add(pat.getAnnotatedType().getJavaClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isOwnProducerOrNonDefaultQualified(Bean<?> bean, Class<?> ownProducerClass) {
        if (ownProducerClass.equals(bean.getBeanClass())) return true;
        if (!bean.getQualifiers().stream().noneMatch(Default.class::isInstance)) return false;
        return true;
    }

    protected void recordProducerField(ProcessProducerField<?, ?> ppf) {
        this.recordProducerMember("recordProducerField", (AnnotatedMember<?>)ppf.getAnnotatedProducerField(), (Bean<?>)ppf.getBean());
    }

    protected void recordProducerMethod(ProcessProducerMethod<?, ?> ppm) {
        this.recordProducerMember("recordProducerMethod", (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod(), (Bean<?>)ppm.getBean());
    }

    protected Map<Bean<?>, AnnotatedMember<?>> producers() {
        return this.producers;
    }

    protected Config rootConfig() {
        if (this.rootConfig == null) {
            this.rootConfig = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig());
        }
        return this.rootConfig;
    }

    protected Config componentConfig() {
        return this.componentConfig(this.rootConfig());
    }

    protected HttpRouting.Builder routingBuilder(ServerCdiExtension server) {
        String routingName = this.componentConfig(this.rootConfig()).get("routing").asString().filter(String::isBlank).orElse("@default");
        return "@default".equals(routingName) ? server.serverRoutingBuilder() : server.serverNamedRoutingBuilder(routingName);
    }

    protected static String nestedConfigKey(String suffix) {
        return "server.features.observe.observers." + suffix;
    }

    public void prepareRuntime(@Observes @RuntimeStart Config config) {
        this.rootConfig = config;
    }

    private Config componentConfig(Config rootConfig) {
        if (this.componentConfig == null) {
            for (String configPrefix : this.configPrefixes) {
                Config componentConfig = rootConfig.get(configPrefix);
                if (!componentConfig.exists()) continue;
                this.componentConfig = componentConfig;
            }
            if (this.componentConfig == null) {
                this.componentConfig = this.configPrefixes.length == 0 ? rootConfig : rootConfig.get(this.configPrefixes[0]);
            }
        }
        return this.componentConfig;
    }

    private void recordProducerMember(String logPrefix, AnnotatedMember<?> member, Bean<?> bean) {
        this.logger.log(System.Logger.Level.DEBUG, () -> logPrefix + " " + String.valueOf(bean.getBeanClass()));
        this.producers.put(bean, member);
    }

    protected static class WorkItemsManager<W> {
        private final Map<Executable, Map<Class<? extends Annotation>, List<W>>> workItemsByExecutable = new HashMap<Executable, Map<Class<? extends Annotation>, List<W>>>();

        private WorkItemsManager() {
        }

        public static <W> WorkItemsManager<W> create() {
            return new WorkItemsManager<W>();
        }

        public void put(Executable executable, Class<? extends Annotation> annotationType, W workItem) {
            List workItems = this.workItemsByExecutable.computeIfAbsent(executable, e -> new HashMap()).computeIfAbsent(annotationType, t -> new ArrayList());
            if (!workItems.contains(workItem)) {
                workItems.add(workItem);
            }
        }

        public Iterable<W> workItems(Executable executable, Class<? extends Annotation> annotationType) {
            return this.workItemsByExecutable.getOrDefault(executable, Collections.emptyMap()).getOrDefault(annotationType, Collections.emptyList());
        }
    }
}

