/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Builder;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.JwtScope;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

abstract class CommonValidator
implements ClaimValidator {
    private final JwtScope scope;
    private final Set<String> claims;

    CommonValidator(BaseBuilder<?, ?> builder) {
        this.scope = builder.scope;
        this.claims = Set.copyOf(builder.claims);
    }

    @Override
    public JwtScope jwtScope() {
        return this.scope;
    }

    @Override
    public Set<String> claims() {
        return this.claims;
    }

    static abstract class BaseBuilder<B extends BaseBuilder<B, T>, T>
    implements Builder<BaseBuilder<B, T>, T> {
        private JwtScope scope = JwtScope.PAYLOAD;
        private Set<String> claims = new HashSet<String>();

        BaseBuilder() {
        }

        B scope(JwtScope scope) {
            this.scope = Objects.requireNonNull(scope);
            return this.me();
        }

        B addClaim(String claim) {
            Objects.requireNonNull(claim);
            this.claims.add(claim);
            return this.me();
        }

        B claims(Set<String> claims) {
            Objects.requireNonNull(claims);
            this.claims = new HashSet<String>(claims);
            return this.me();
        }

        B clearClaims() {
            this.claims.clear();
            return this.me();
        }

        JwtScope scope() {
            return this.scope;
        }

        protected B me() {
            return (B)this;
        }
    }
}

