/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.common;

import io.helidon.common.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.config.metadata.ConfiguredOptions;
import io.helidon.security.providers.common.EvictableCacheImpl;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public interface EvictableCache<K, V> {
    public static final long CACHE_TIMEOUT_MINUTES = 60L;
    public static final long CACHE_EVICT_PERIOD_MINUTES = 5L;
    public static final long CACHE_EVICT_DELAY_MINUTES = 1L;
    public static final long CACHE_MAX_SIZE = 100000L;
    public static final long EVICT_PARALLELISM_THRESHOLD = 10000L;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> EvictableCache<K, V> create() {
        Builder<K, V> builder = EvictableCache.builder();
        return builder.build();
    }

    public static <K, V> EvictableCache<K, V> create(Config config) {
        Builder<K, V> builder = EvictableCache.builder();
        return builder.config(config).build();
    }

    public static <K, V> EvictableCache<K, V> noCache() {
        return EvictableCacheImpl.NO_CACHE;
    }

    default public Optional<V> remove(K key) {
        return Optional.empty();
    }

    default public Optional<V> get(K key) {
        return Optional.empty();
    }

    default public int size() {
        return 0;
    }

    default public Optional<V> computeValue(K key, Supplier<Optional<V>> valueSupplier) {
        return valueSupplier.get();
    }

    default public void close() {
    }

    @Configured
    public static class Builder<K, V>
    implements io.helidon.common.Builder<Builder<K, V>, EvictableCache<K, V>> {
        private boolean cacheEnabled = true;
        private long cacheTimeout = 60L;
        private TimeUnit cacheTimeoutUnit = TimeUnit.MINUTES;
        private long overallTimeout = 60L;
        private TimeUnit overallTimeoutUnit = TimeUnit.MINUTES;
        private long cacheMaxSize = 100000L;
        private long cacheEvictDelay = 1L;
        private long cacheEvictPeriod = 5L;
        private TimeUnit cacheEvictTimeUnit = TimeUnit.MINUTES;
        private long parallelismThreshold = 10000L;
        private BiFunction<K, V, Boolean> evictor = (key, value) -> false;

        public EvictableCache<K, V> build() {
            if (this.cacheEnabled) {
                return new EvictableCacheImpl(this);
            }
            return EvictableCache.noCache();
        }

        @ConfiguredOption(key="cache-timeout-millis", value="3600000", type=Long.class)
        public Builder<K, V> timeout(long timeout, TimeUnit timeoutUnit) {
            this.cacheTimeout = timeout;
            this.cacheTimeoutUnit = timeoutUnit;
            return this;
        }

        @ConfiguredOption(key="cache-overall-timeout-millis", value="3600000", type=Long.class)
        public Builder<K, V> overallTimeout(long timeout, TimeUnit timeoutUnit) {
            this.overallTimeout = timeout;
            this.overallTimeoutUnit = timeoutUnit;
            return this;
        }

        @ConfiguredOption(value="100000")
        public Builder<K, V> maxSize(long cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        @ConfiguredOptions(value={@ConfiguredOption(key="cache-evict-delay-millis", value="60000", type=Long.class, description="Delay from the creation of the cache to first eviction"), @ConfiguredOption(key="cache-evict-period-millis", value="300000", type=Long.class, description="How often to evict records")})
        public Builder<K, V> evictSchedule(long evictDelay, long evictPeriod, TimeUnit evictTimeUnit) {
            this.cacheEvictDelay = evictDelay;
            this.cacheEvictPeriod = evictPeriod;
            this.cacheEvictTimeUnit = evictTimeUnit;
            return this;
        }

        @ConfiguredOption(value="10000")
        public Builder<K, V> parallelismThreshold(long parallelismThreshold) {
            this.parallelismThreshold = parallelismThreshold;
            return this;
        }

        @ConfiguredOption(key="evictor-class", type=Class.class)
        public Builder<K, V> evictor(BiFunction<K, V, Boolean> evictor) {
            this.evictor = evictor;
            return this;
        }

        @ConfiguredOption(value="true")
        public Builder<K, V> cacheEnabled(boolean cacheEnabled) {
            this.cacheEnabled = cacheEnabled;
            return this;
        }

        public Builder<K, V> config(Config config) {
            config.get("cache-enabled").asBoolean().ifPresent(this::cacheEnabled);
            if (this.cacheEnabled) {
                config.get("max-size").asInt().ifPresent(this::maxSize);
                config.get("cache-timeout-millis").asLong().ifPresent(timeout -> this.timeout((long)timeout, TimeUnit.MILLISECONDS));
                config.get("cache-overall-timeout-millis").asLong().ifPresent(timeout -> this.overallTimeout((long)timeout, TimeUnit.MILLISECONDS));
                long evictDelay = (Long)config.get("cache-evict-delay-millis").asLong().orElse((Object)this.cacheEvictTimeUnit.toMillis(this.cacheEvictDelay));
                long evictPeriod = (Long)config.get("cache-evict-period-millis").asLong().orElse((Object)this.cacheEvictTimeUnit.toMillis(this.cacheEvictPeriod));
                this.evictSchedule(evictDelay, evictPeriod, TimeUnit.MILLISECONDS);
                config.get("parallelism-treshold").asLong().ifPresent(this::parallelismThreshold);
                config.get("evictor-class").as(Class.class).ifPresent(this::evictorClass);
            }
            return this;
        }

        private Builder<K, V> evictorClass(Class<?> aClass) {
            try {
                aClass.getMethod("apply", Object.class, Object.class);
                Object anObject = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.evictor((BiFunction)anObject);
            }
            catch (ReflectiveOperationException e) {
                throw new SecurityException("Failed to create an evictor instance. Configured class: " + aClass.getName(), e);
            }
            return this;
        }

        long cacheTimeout() {
            return this.cacheTimeout;
        }

        TimeUnit cacheTimeoutUnit() {
            return this.cacheTimeoutUnit;
        }

        long overallTimeout() {
            return this.overallTimeout;
        }

        TimeUnit overallTimeoutUnit() {
            return this.overallTimeoutUnit;
        }

        long cacheMaxSize() {
            return this.cacheMaxSize;
        }

        long cacheEvictDelay() {
            return this.cacheEvictDelay;
        }

        long cacheEvictPeriod() {
            return this.cacheEvictPeriod;
        }

        TimeUnit cacheEvictTimeUnit() {
            return this.cacheEvictTimeUnit;
        }

        long parallelismThreshold() {
            return this.parallelismThreshold;
        }

        BiFunction<K, V, Boolean> evictor() {
            return this.evictor;
        }
    }
}

