/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.common;

import io.helidon.security.ClassToInstanceStore;
import java.time.Instant;
import java.util.Optional;

public class TokenCredential {
    private final Optional<String> issuer;
    private final Optional<Instant> issueTime;
    private final Optional<Instant> expTime;
    private final String token;
    private final ClassToInstanceStore<Object> tokens = new ClassToInstanceStore();

    private TokenCredential(Builder builder) {
        this.token = builder.token;
        this.issuer = Optional.ofNullable(builder.issuer);
        this.issueTime = Optional.ofNullable(builder.issueTime);
        this.expTime = Optional.ofNullable(builder.expTime);
        this.tokens.putAll(builder.tokens);
    }

    public static TokenCredential create(String token, String issuer, Instant issueTime, Instant expTime) {
        return TokenCredential.builder().token(token).issuer(issuer).issueTime(issueTime).expTime(expTime).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String token() {
        return this.token;
    }

    public Optional<Instant> getIssueTime() {
        return this.issueTime;
    }

    public Optional<Instant> getExpTime() {
        return this.expTime;
    }

    public Optional<String> getIssuer() {
        return this.issuer;
    }

    public <U> Optional<U> getTokenInstance(Class<U> tokenClass) {
        return this.tokens.getInstance(tokenClass);
    }

    public String toString() {
        return "TokenCredential{issuer='" + String.valueOf(this.issuer) + "', issueTime=" + String.valueOf(this.issueTime) + ", expTime=" + String.valueOf(this.expTime) + "}";
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, TokenCredential> {
        private final ClassToInstanceStore<Object> tokens = new ClassToInstanceStore();
        private Instant issueTime;
        private Instant expTime;
        private String issuer;
        private String token;

        private Builder() {
        }

        public Builder token(String token) {
            this.token = token;
            this.addToken(String.class, token);
            return this;
        }

        public Builder issueTime(Instant issueTime) {
            this.issueTime = issueTime;
            return this;
        }

        public Builder expTime(Instant expirationTime) {
            this.expTime = expirationTime;
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public <T, U extends T> Builder addToken(Class<T> tokenClass, U tokenInstance) {
            this.tokens.putInstance(tokenClass, tokenInstance);
            return this;
        }

        public Builder addToken(Object token) {
            this.tokens.putInstance(token);
            return this;
        }

        public TokenCredential build() {
            return new TokenCredential(this);
        }
    }
}

