/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.httpauth;

import io.helidon.common.config.Config;
import java.util.Arrays;

public class HttpDigest {

    public static enum Qop {
        NONE("none"),
        AUTH("auth");

        private final String qop;

        private Qop(String qop) {
            this.qop = qop;
        }

        public static Qop create(Config config) {
            return Qop.fromString((String)config.asString().get());
        }

        static Qop fromString(String value) {
            if (null == value) {
                return NONE;
            }
            for (Qop qop : Qop.values()) {
                if (!qop.getQop().equals(value)) continue;
                return qop;
            }
            throw new IllegalArgumentException("Invalid QOP for digest: " + value + ", allowed: " + Arrays.toString((Object[])Qop.values()));
        }

        public String getQop() {
            return this.qop;
        }
    }

    public static enum Algorithm {
        MD5("MD5");

        private final String algorithm;

        private Algorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

