/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.security.jwt.jwk.JwkKeys;
import io.helidon.security.providers.oidc.common.BaseBuilder;
import io.helidon.security.providers.oidc.common.OidcConfig;
import io.helidon.security.providers.oidc.common.TenantConfig;
import jakarta.json.JsonObject;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;

class TenantConfigImpl
implements TenantConfig {
    private static final System.Logger LOGGER = System.getLogger(TenantConfigImpl.class.getName());
    private final URI authorizationEndpointUri;
    private final String clientId;
    private final URI identityUri;
    private final URI tokenEndpointUri;
    private final String baseScopes;
    private final boolean validateJwtWithJwk;
    private final String issuer;
    private final String audience;
    private final boolean checkAudience;
    private final String realm;
    private final OidcConfig.ClientAuthentication tokenEndpointAuthentication;
    private final Duration clientTimeout;
    private final JwkKeys signJwk;
    private final String clientSecret;
    private final URI introspectUri;
    private final URI logoutEndpointUri;
    private final String scopeAudience;
    private final String serverType;
    private final JsonObject oidcMetadata;
    private final boolean useWellKnown;
    private final String name;

    TenantConfigImpl(BaseBuilder<?, ?> builder) {
        String tmp;
        this.name = builder.name();
        this.clientId = builder.clientId();
        this.baseScopes = builder.baseScopes();
        this.validateJwtWithJwk = builder.validateJwtWithJwk();
        this.issuer = builder.issuer();
        this.audience = builder.audience();
        this.checkAudience = builder.checkAudience();
        this.identityUri = builder.identityUri();
        this.realm = builder.realm();
        this.tokenEndpointUri = builder.tokenEndpointUri();
        this.tokenEndpointAuthentication = builder.tokenEndpointAuthentication();
        this.clientTimeout = builder.clientTimeout();
        this.authorizationEndpointUri = builder.authorizationEndpointUri();
        this.logoutEndpointUri = builder.logoutEndpointUri();
        this.serverType = builder.serverType();
        this.clientSecret = builder.clientSecret();
        this.signJwk = builder.signJwk();
        this.oidcMetadata = builder.oidcMetadata();
        this.useWellKnown = builder.useWellKnown();
        this.introspectUri = this.validateJwtWithJwk ? null : builder.introspectUri();
        this.scopeAudience = builder.scopeAudience() == null || builder.scopeAudience().trim().isEmpty() ? "" : ((tmp = builder.scopeAudience().trim()).endsWith("/") ? tmp : tmp + "/");
        LOGGER.log(System.Logger.Level.TRACE, () -> "OIDC Scope audience: " + this.scopeAudience);
    }

    @Override
    public Optional<JwkKeys> tenantSignJwk() {
        return Optional.ofNullable(this.signJwk);
    }

    @Override
    public Optional<URI> tenantLogoutEndpointUri() {
        return Optional.ofNullable(this.logoutEndpointUri);
    }

    @Override
    public Optional<URI> tenantTokenEndpointUri() {
        return Optional.ofNullable(this.tokenEndpointUri);
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String baseScopes() {
        return this.baseScopes;
    }

    @Override
    public boolean validateJwtWithJwk() {
        return this.validateJwtWithJwk;
    }

    @Override
    public Optional<URI> tenantIntrospectUri() {
        return Optional.ofNullable(this.introspectUri);
    }

    @Override
    public Optional<String> tenantIssuer() {
        return Optional.ofNullable(this.issuer);
    }

    @Override
    public String audience() {
        return this.audience;
    }

    @Override
    public boolean checkAudience() {
        return this.checkAudience;
    }

    @Override
    public String scopeAudience() {
        return this.scopeAudience;
    }

    @Override
    public URI identityUri() {
        return this.identityUri;
    }

    @Override
    public String realm() {
        return this.realm;
    }

    @Override
    public OidcConfig.ClientAuthentication tokenEndpointAuthentication() {
        return this.tokenEndpointAuthentication;
    }

    @Override
    public Duration clientTimeout() {
        return this.clientTimeout;
    }

    @Override
    public Optional<URI> authorizationEndpoint() {
        return Optional.ofNullable(this.authorizationEndpointUri);
    }

    @Override
    public String clientSecret() {
        return this.clientSecret;
    }

    @Override
    public String serverType() {
        return this.serverType;
    }

    @Override
    public JsonObject oidcMetadata() {
        return this.oidcMetadata;
    }

    @Override
    public boolean useWellKnown() {
        return this.useWellKnown;
    }
}

