/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.Qualifiers;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.InjectCodegenObserver;
import io.helidon.service.codegen.spi.InjectCodegenObserverProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;

public class EventEmitterObserverProvider
implements InjectCodegenObserverProvider {
    @Override
    public InjectCodegenObserver create(RegistryCodegenContext context) {
        return new EventEmitterObserver();
    }

    private static final class EventEmitterObserver
    implements InjectCodegenObserver {
        private static final TypeName GENERATOR = TypeName.create(EventEmitterObserver.class);
        private static final Map<ClassNameCacheKey, Map<Set<Annotation>, TypeName>> CACHE = new ConcurrentHashMap<ClassNameCacheKey, Map<Set<Annotation>, TypeName>>();

        private EventEmitterObserver() {
        }

        @Override
        public void onInjectionPoint(RegistryRoundContext roundContext, TypeInfo service, TypedElementInfo element, TypedElementInfo argument) {
            TypeName typeName = argument.typeName();
            if (typeName.equals((Object)ServiceCodegenTypes.EVENT_EMITTER)) {
                if (typeName.typeArguments().isEmpty()) {
                    throw new CodegenException("Cannot generate an event emitter when type argument is missing", argument.originatingElementValue());
                }
                Set<Annotation> qualifiers = Qualifiers.qualifiers((Annotated)argument);
                TypeName eventObject = (TypeName)typeName.typeArguments().getFirst();
                TypeName generatedType = EventEmitterObserver.emitterTypeName(service.typeName(), eventObject, qualifiers);
                if (roundContext.generatedType(generatedType).isEmpty()) {
                    this.generateEventEmitter(roundContext, service, generatedType, service.typeName(), eventObject, qualifiers);
                }
            }
        }

        private static TypeName emitterTypeName(TypeName serviceType, TypeName eventObject, Set<Annotation> qualifiers) {
            ResolvedType event = ResolvedType.create((TypeName)eventObject);
            Map map = CACHE.computeIfAbsent(new ClassNameCacheKey(serviceType, event), k -> new ConcurrentHashMap());
            return map.computeIfAbsent(qualifiers, it -> {
                String className = serviceType.classNameWithEnclosingNames().replace('.', '_') + "__Emitter";
                TypeName.Builder builder = (TypeName.Builder)TypeName.builder().packageName(serviceType.packageName());
                if (map.isEmpty()) {
                    return ((TypeName.Builder)builder.className(className)).build();
                }
                return ((TypeName.Builder)builder.className(className + "_" + map.size())).build();
            });
        }

        private void generateEventEmitter(RegistryRoundContext roundContext, TypeInfo serviceInfo, TypeName generatedType, TypeName serviceTypeName, TypeName eventObject, Set<Annotation> qualifiers) {
            ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)generatedType, (String)"1", (String)""))).type(generatedType).accessModifier(AccessModifier.PACKAGE_PRIVATE).description("Event emitter service for {@link " + eventObject.fqName() + "}.")).addInterface(this.emitterInterface(eventObject))).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON));
            classModel.addField(eventObjectConstant -> ((Field.Builder)eventObjectConstant.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).type(TypeNames.RESOLVED_TYPE_NAME).name("EVENT_OBJECT")).addContentCreate(ResolvedType.create((TypeName)eventObject)));
            if (!qualifiers.isEmpty()) {
                Qualifiers.generateQualifiersConstant(classModel, qualifiers);
            }
            classModel.addField(eventManager -> eventManager.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(ServiceCodegenTypes.EVENT_MANAGER).name("manager"));
            classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(eventManager -> eventManager.type(ServiceCodegenTypes.EVENT_MANAGER).name("manager"))).addContentLine("this.manager = manager;"));
            boolean qualified = !qualifiers.isEmpty();
            this.addEmit(classModel, "emit", eventObject, TypeNames.PRIMITIVE_VOID, qualified);
            this.addEmit(classModel, "emitAsync", eventObject, this.completionStage(eventObject), qualified);
            if (qualified) {
                this.addMergeQualifiers(classModel);
                qualifiers.forEach(it -> classModel.addAnnotation(it));
            }
            roundContext.addGeneratedType(generatedType, classModel, serviceTypeName, new Object[]{serviceInfo});
        }

        private void addMergeQualifiers(ClassModel.Builder classModel) {
            classModel.addMethod(merge -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)merge.accessModifier(AccessModifier.PRIVATE)).isStatic(true).name("mergeQualifiers")).addParameter(qualifiers -> ((Parameter.Builder)qualifiers.name("qualifiers")).type(ServiceCodegenTypes.SERVICE_QUALIFIER).vararg(true))).returnType(ServiceCodegenTypes.SET_OF_QUALIFIERS).addContentLine("if (qualifiers.length == 0) {")).addContentLine("return QUALIFIERS;")).addContentLine("}")).addContent("var qualifierSet = new ")).addContent(HashSet.class)).addContentLine("<>(QUALIFIERS);")).addContent("qualifierSet.addAll(")).addContent(Set.class)).addContentLine(".of(qualifiers));")).addContentLine("return qualifierSet;"));
        }

        private void addEmit(ClassModel.Builder classModel, String methodName, TypeName eventObject, TypeName returnType, boolean isQualified) {
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(returnType).name(methodName)).addParameter(event -> event.type(eventObject).name("eventObject"))).addParameter(qualifiers -> qualifiers.vararg(true).type(ServiceCodegenTypes.SERVICE_QUALIFIER).name("qualifiers"))).update(it -> {
                if (!returnType.equals((Object)TypeNames.PRIMITIVE_VOID)) {
                    it.addContent("return ");
                }
            })).addContent("manager.")).addContent(methodName)).update(it -> {
                if (isQualified) {
                    it.addContentLine("(EVENT_OBJECT, eventObject, mergeQualifiers(qualifiers));");
                } else {
                    ((Method.Builder)((Method.Builder)it.addContent("(EVENT_OBJECT, eventObject, ")).addContent(Set.class)).addContentLine(".of(qualifiers));");
                }
            }));
        }

        private TypeName completionStage(TypeName eventObject) {
            return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create(CompletionStage.class))).addTypeArgument(eventObject)).build();
        }

        private TypeName emitterInterface(TypeName eventObject) {
            return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(ServiceCodegenTypes.EVENT_EMITTER)).addTypeArgument(eventObject)).build();
        }
    }

    private record ClassNameCacheKey(TypeName serviceType, ResolvedType eventType) {
    }
}

