/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class QualifierSupport {
    QualifierSupport() {
    }

    static final class CustomMethods {
        @Prototype.Constant
        static final Qualifier WILDCARD_NAMED = CustomMethods.createNamed("*");
        @Prototype.Constant
        static final Qualifier DEFAULT_NAMED = CustomMethods.createNamed("@default");
        @Prototype.Constant
        static final Qualifier CREATE_FOR_NAME = CustomMethods.create(Service.InstanceName.class);

        private CustomMethods() {
        }

        @Prototype.FactoryMethod
        static Qualifier create(Class<? extends Annotation> qualifierType) {
            Objects.requireNonNull(qualifierType);
            TypeName typeName = TypeName.create(qualifierType);
            TypeName qualifierTypeName = CustomMethods.maybeNamed(typeName);
            return ((Qualifier.Builder)Qualifier.builder().typeName(qualifierTypeName)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier create(Class<? extends Annotation> qualifierType, String value) {
            Objects.requireNonNull(qualifierType);
            TypeName typeName = TypeName.create(qualifierType);
            TypeName qualifierTypeName = CustomMethods.maybeNamed(typeName);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(qualifierTypeName)).putValue("value", value)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier create(TypeName qualifierType) {
            Objects.requireNonNull(qualifierType);
            TypeName qualifierTypeName = CustomMethods.maybeNamed(qualifierType);
            return ((Qualifier.Builder)Qualifier.builder().typeName(qualifierTypeName)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier create(TypeName qualifierType, String value) {
            Objects.requireNonNull(qualifierType);
            TypeName qualifierTypeName = CustomMethods.maybeNamed(qualifierType);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(qualifierTypeName)).putValue("value", value)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier create(io.helidon.common.types.Annotation annotation) {
            Objects.requireNonNull(annotation);
            if (annotation instanceof Qualifier) {
                Qualifier qualifier = (Qualifier)annotation;
                return qualifier;
            }
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(CustomMethods.maybeNamed(annotation.typeName()))).values(CustomMethods.removeEmptyProperties(annotation.values()))).build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(String name) {
            Objects.requireNonNull(name);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(Service.Named.TYPE)).value(name)).build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(Service.Named name) {
            Objects.requireNonNull(name);
            Qualifier.Builder builder = (Qualifier.Builder)Qualifier.builder().typeName(Service.Named.TYPE);
            if (!name.value().isEmpty()) {
                builder.value(name.value());
            }
            return builder.build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(Service.NamedByType name) {
            Objects.requireNonNull(name);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(Service.Named.TYPE)).value(name.value().getName())).build();
        }

        @Prototype.FactoryMethod
        static Qualifier createNamed(Class<?> className) {
            Objects.requireNonNull(className);
            return ((Qualifier.Builder)((Qualifier.Builder)Qualifier.builder().typeName(Service.Named.TYPE)).value(className.getName())).build();
        }

        private static TypeName maybeNamed(TypeName qualifierType) {
            if (Service.NamedByType.TYPE.equals((Object)qualifierType)) {
                return Service.Named.TYPE;
            }
            return qualifierType;
        }

        private static Map<String, Object> removeEmptyProperties(Map<String, Object> values) {
            HashMap<String, Object> result = new HashMap<String, Object>(values);
            result.entrySet().removeIf(entry -> {
                String str;
                Object value = entry.getValue();
                return value instanceof String && (str = (String)value).isBlank();
            });
            return result;
        }
    }
}

