/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.LookupTrace;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.service.registry.ServiceManager;
import io.helidon.service.registry.ServiceRegistryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ServiceSupplies {
    private ServiceSupplies() {
    }

    private static <T> Optional<ServiceInstance<T>> oneInstance(Lookup lookup, List<ServiceManager<T>> serviceManagers) {
        LookupTrace.traceLookup(lookup, "explode, filter, and sort", new Object[0]);
        for (ServiceManager serviceManager : serviceManagers) {
            Optional<ServiceInstance<ServiceInstance>> thisManager = serviceManager.activator().instances(lookup).stream().flatMap(Collection::stream).map(it -> serviceManager.registryInstance(lookup, (Service.QualifiedInstance)it)).findFirst();
            LookupTrace.traceLookupInstance(lookup, serviceManager, thisManager.map(List::of).orElseGet(List::of));
            if (!thisManager.isPresent()) continue;
            return thisManager;
        }
        return Optional.empty();
    }

    private static <T> List<ServiceInstance<T>> explodeFilterAndSort(Lookup lookup, List<ServiceManager<T>> serviceManagers) {
        LookupTrace.traceLookup(lookup, "explode, filter, and sort", new Object[0]);
        ArrayList<ServiceInstance<Object>> result = new ArrayList();
        for (ServiceManager<T> serviceManager : serviceManagers) {
            ArrayList thisManager = new ArrayList();
            serviceManager.activator().instances(lookup).stream().flatMap(Collection::stream).map(it -> serviceManager.registryInstance(lookup, (Service.QualifiedInstance)it)).forEach(thisManager::add);
            LookupTrace.traceLookupInstance(lookup, serviceManager, thisManager);
            result.addAll(thisManager);
        }
        if (result.isEmpty() || result.size() == 1) {
            LookupTrace.traceLookupInstances(lookup, result);
            return List.copyOf(result);
        }
        if (lookup.qualifiers().isEmpty()) {
            ArrayList<ServiceInstance<Object>> unqualified = new ArrayList<ServiceInstance<Object>>();
            ArrayList<ServiceInstance> qualified = new ArrayList<ServiceInstance>();
            for (ServiceInstance serviceInstance : result) {
                if (serviceInstance.qualifiers().isEmpty()) {
                    unqualified.add(serviceInstance);
                    continue;
                }
                qualified.add(serviceInstance);
            }
            unqualified.addAll(qualified);
            result = unqualified;
        }
        LookupTrace.traceLookupInstances(lookup, result);
        return List.copyOf(result);
    }

    static class ServiceInstanceSupplyList<T>
    extends ServiceSupplyBase<T>
    implements Supplier<List<ServiceInstance<T>>> {
        ServiceInstanceSupplyList(Lookup lookup, List<ServiceManager<T>> managers) {
            super(lookup, managers);
        }

        @Override
        public List<ServiceInstance<T>> get() {
            return ServiceSupplies.explodeFilterAndSort(this.lookup, this.managers).stream().collect(Collectors.toUnmodifiableList());
        }
    }

    static class ServiceSupplyList<T>
    extends ServiceSupplyBase<T>
    implements Supplier<List<T>> {
        ServiceSupplyList(Lookup lookup, List<ServiceManager<T>> managers) {
            super(lookup, managers);
        }

        @Override
        public List<T> get() {
            Stream stream = ServiceSupplies.explodeFilterAndSort(this.lookup, this.managers).stream();
            return stream.map(Supplier::get).toList();
        }
    }

    static class ServiceInstanceSupplyOptional<T>
    extends ServiceSupplyBase<T>
    implements Supplier<Optional<ServiceInstance<T>>> {
        ServiceInstanceSupplyOptional(Lookup lookup, List<ServiceManager<T>> managers) {
            super(lookup, managers);
        }

        @Override
        public Optional<ServiceInstance<T>> get() {
            return ServiceSupplies.oneInstance(this.lookup, this.managers);
        }
    }

    static class ServiceSupplyOptional<T>
    extends ServiceSupplyBase<T>
    implements Supplier<Optional<T>> {
        ServiceSupplyOptional(Lookup lookup, List<ServiceManager<T>> managers) {
            super(lookup, managers);
        }

        @Override
        public Optional<T> get() {
            Optional<ServiceInstance<ServiceInstance>> first = ServiceSupplies.oneInstance(this.lookup, this.managers);
            return first.map(Supplier::get);
        }
    }

    static class ServiceSupply<T>
    extends ServiceSupplyBase<T>
    implements Supplier<T> {
        private final Supplier<T> value;

        ServiceSupply(Lookup lookup, List<ServiceManager<T>> managers) {
            super(lookup, managers);
            Supplier<Object> supplier = () -> ServiceSupplies.oneInstance(lookup, managers).map(Service.QualifiedInstance::get).orElseThrow(() -> new ServiceRegistryException("Neither of matching services could provide a value. Descriptors: " + String.valueOf(managers) + ", lookup: " + String.valueOf(this.lookup)));
            this.value = supplier;
        }

        @Override
        public T get() {
            return this.value.get();
        }
    }

    static class ServiceInstanceSupply<T>
    extends ServiceSupplyBase<T>
    implements Supplier<ServiceInstance<T>> {
        private final Supplier<ServiceInstance<T>> value;

        ServiceInstanceSupply(Lookup lookup, List<ServiceManager<T>> managers) {
            super(lookup, managers);
            Supplier<ServiceInstance> supplier = () -> (ServiceInstance)ServiceSupplies.explodeFilterAndSort(lookup, managers).stream().findFirst().orElseThrow(() -> new ServiceRegistryException("Neither of matching services could provide a value. Descriptors: " + String.valueOf(managers) + ", lookup: " + String.valueOf(this.lookup)));
            this.value = supplier;
        }

        @Override
        public ServiceInstance<T> get() {
            return this.value.get();
        }
    }

    private static class ServiceSupplyBase<T> {
        private final Lookup lookup;
        private final List<ServiceManager<T>> managers;

        private ServiceSupplyBase(Lookup lookup, List<ServiceManager<T>> managers) {
            this.managers = managers;
            this.lookup = lookup;
        }

        public String toString() {
            return this.managers.stream().map(ServiceManager::descriptor).map(ServiceInfo::serviceType).map(rec$ -> ((TypeName)rec$).fqName()).collect(Collectors.joining(", "));
        }
    }
}

