/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.config;

import io.helidon.common.config.Config;
import io.helidon.tracing.config.ComponentTracingConfig;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.Traceable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class TracingConfig
extends Traceable {
    public static final TracingConfig ENABLED = TracingConfig.builder().build();
    public static final TracingConfig DISABLED = TracingConfig.builder().enabled(false).build();

    protected TracingConfig(String name) {
        super(name);
    }

    protected abstract Optional<ComponentTracingConfig> getComponent(String var1);

    public ComponentTracingConfig component(String componentName) {
        return this.component(componentName, true);
    }

    public ComponentTracingConfig component(String componentName, boolean enabledByDefault) {
        if (this.enabled()) {
            return this.getComponent(componentName).orElseGet(() -> enabledByDefault ? ComponentTracingConfig.ENABLED : ComponentTracingConfig.DISABLED);
        }
        return ComponentTracingConfig.DISABLED;
    }

    public String toString() {
        return "TracingConfig(" + this.name() + ")";
    }

    public static TracingConfig create(Config config) {
        return TracingConfig.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TracingConfig merge(final TracingConfig older, final TracingConfig newer) {
        return new TracingConfig(newer.name()){

            @Override
            public Optional<ComponentTracingConfig> getComponent(String componentName) {
                Optional<ComponentTracingConfig> newerComponent = newer.getComponent(componentName);
                Optional<ComponentTracingConfig> olderComponent = older.getComponent(componentName);
                if (newerComponent.isPresent() && olderComponent.isPresent()) {
                    return Optional.of(ComponentTracingConfig.merge(olderComponent.get(), newerComponent.get()));
                }
                if (newerComponent.isPresent()) {
                    return newerComponent;
                }
                return olderComponent;
            }

            @Override
            public Optional<Boolean> isEnabled() {
                return newer.isEnabled().or(older::isEnabled);
            }
        };
    }

    public SpanTracingConfig spanConfig(String component, String spanName) {
        return this.component(component).span(spanName);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, TracingConfig> {
        private final Map<String, ComponentTracingConfig> components = new HashMap<String, ComponentTracingConfig>();
        private Optional<Boolean> enabled = Optional.empty();

        private Builder() {
        }

        public TracingConfig build() {
            return new RootTracingConfig("helidon", new HashMap<String, ComponentTracingConfig>(this.components), this.enabled);
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            Config compConfig = config.get("components");
            compConfig.asNodeList().ifPresent(compList -> compList.forEach(componentConfig -> this.addComponent(ComponentTracingConfig.create(componentConfig.name(), componentConfig))));
            return this;
        }

        public Builder addComponent(ComponentTracingConfig component) {
            this.components.put(component.name(), component);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }
    }

    static final class RootTracingConfig
    extends TracingConfig {
        private final Map<String, ComponentTracingConfig> components;
        private final Optional<Boolean> enabled;

        RootTracingConfig(String name, Map<String, ComponentTracingConfig> components, Optional<Boolean> enabled) {
            super(name);
            this.components = components;
            this.enabled = enabled;
        }

        @Override
        public Optional<ComponentTracingConfig> getComponent(String componentName) {
            return Optional.ofNullable(this.components.get(componentName));
        }

        @Override
        public Optional<Boolean> isEnabled() {
            return this.enabled;
        }
    }
}

