/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.config;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfig;

public final class TracingConfigUtil {
    public static final Object OUTBOUND_SPAN_QUALIFIER = OutboundSpanQualifier.class;

    private TracingConfigUtil() {
    }

    public static SpanTracingConfig spanConfig(String component, String spanName) {
        return Contexts.context().flatMap(ctx -> ctx.get(TracingConfig.class)).map(tracedConfig -> tracedConfig.spanConfig(component, spanName)).orElse(SpanTracingConfig.ENABLED);
    }

    public static SpanTracingConfig spanConfig(String component, String spanName, Context context) {
        return context.get(TracingConfig.class).map(tracedConfig -> tracedConfig.spanConfig(component, spanName)).orElse(SpanTracingConfig.ENABLED);
    }

    public static SpanTracingConfig spanConfig(String component, String spanName, boolean defaultEnabled) {
        return Contexts.context().flatMap(ctx -> ctx.get(TracingConfig.class)).map(tracingConfig -> tracingConfig.component(component, defaultEnabled)).map(tracingComponent -> tracingComponent.span(spanName, defaultEnabled)).orElseGet(() -> defaultEnabled ? SpanTracingConfig.ENABLED : SpanTracingConfig.DISABLED);
    }

    private static final class OutboundSpanQualifier {
        private OutboundSpanQualifier() {
        }
    }
}

