/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.media.type.MediaType;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Method;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.webserver.staticcontent.StaticContentHandler;
import io.helidon.webserver.staticcontent.TemporaryStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Optional;
import java.util.function.BiConsumer;

class CachedHandlerJar
implements CachedHandler {
    private static final System.Logger LOGGER = System.getLogger(CachedHandlerJar.class.getName());
    private final MediaType mediaType;
    private final Header contentLength;
    private final Instant lastModified;
    private final BiConsumer<ServerResponseHeaders, Instant> setLastModifiedHeader;
    private final Path path;
    private final URL url;

    private CachedHandlerJar(MediaType mediaType, URL url, long contentLength, Instant lastModified, BiConsumer<ServerResponseHeaders, Instant> setLastModifiedHeader, Path path) {
        this.mediaType = mediaType;
        this.url = url;
        this.contentLength = HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (boolean)true, (boolean)false, (long)contentLength);
        this.lastModified = lastModified;
        this.setLastModifiedHeader = setLastModifiedHeader;
        this.path = path;
    }

    static CachedHandlerJar create(TemporaryStorage tmpStorage, URL fileUrl, Instant lastModified, MediaType mediaType, long contentLength) {
        BiConsumer<ServerResponseHeaders, Instant> headerHandler = CachedHandlerJar.headerHandler(lastModified);
        Optional<Path> createdTmpFile = tmpStorage.createFile();
        if (createdTmpFile.isPresent()) {
            Path tmpFile = createdTmpFile.get();
            try (InputStream is = fileUrl.openStream();){
                Files.copy(is, tmpFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.TRACE, "Failed to create temporary extracted file for " + String.valueOf(fileUrl), (Throwable)e);
            }
            return new CachedHandlerJar(mediaType, fileUrl, contentLength, lastModified, headerHandler, tmpFile);
        }
        return new CachedHandlerJar(mediaType, fileUrl, contentLength, lastModified, headerHandler, null);
    }

    @Override
    public boolean handle(LruCache<String, CachedHandler> cache, Method method, ServerRequest request, ServerResponse response, String requestedResource) throws IOException {
        block19: {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Sending static content from jar: " + requestedResource);
            }
            if (this.lastModified != null) {
                StaticContentHandler.processEtag(String.valueOf(this.lastModified.toEpochMilli()), request.headers(), response.headers());
                StaticContentHandler.processModifyHeaders(this.lastModified, request.headers(), response.headers(), this.setLastModifiedHeader);
            }
            response.headers().contentType(this.mediaType);
            if (method == Method.GET) {
                block18: {
                    try {
                        if (this.path != null && Files.exists(this.path, new LinkOption[0])) {
                            FileBasedContentHandler.send(request, response, this.path);
                            return true;
                        }
                    }
                    catch (IOException e) {
                        if (!LOGGER.isLoggable(System.Logger.Level.TRACE)) break block18;
                        LOGGER.log(System.Logger.Level.TRACE, "Failed to send jar entry from extracted path: " + String.valueOf(this.path) + ", will send directly from jar", (Throwable)e);
                    }
                }
                try (InputStream in = this.url.openStream();
                     OutputStream out = response.outputStream();){
                    in.transferTo(out);
                    break block19;
                }
            }
            response.headers().set(this.contentLength);
            response.send();
        }
        return true;
    }

    private static BiConsumer<ServerResponseHeaders, Instant> headerHandler(Instant lastModified) {
        if (lastModified == null) {
            return (headers, instant) -> {};
        }
        Header instantHeader = HeaderValues.create((HeaderName)HeaderNames.LAST_MODIFIED, (boolean)true, (boolean)false, (String[])new String[]{StaticContentHandler.formatLastModified(lastModified)});
        return (headers, instant) -> headers.set(instantHeader);
    }
}

