/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.Size;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.webserver.staticcontent.MemoryCache;
import io.helidon.webserver.staticcontent.MemoryCacheConfigBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.staticcontent.MemoryCacheConfigBlueprint")
public interface MemoryCacheConfig
extends MemoryCacheConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MemoryCacheConfig instance) {
        return (Builder)MemoryCacheConfig.builder().from(instance);
    }

    public static MemoryCacheConfig create(Config config) {
        return ((Builder)MemoryCacheConfig.builder().config(config)).buildPrototype();
    }

    public static MemoryCacheConfig create() {
        return MemoryCacheConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, MemoryCacheConfig>
    implements io.helidon.common.Builder<Builder, MemoryCache> {
        private Builder() {
        }

        public MemoryCacheConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.MemoryCacheConfigImpl(this);
        }

        public MemoryCache build() {
            return MemoryCache.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends MemoryCacheConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean enabled = true;
        private Config config;
        private Size capacity = Size.parse((String)"50 mB");

        protected BuilderBase() {
        }

        public BUILDER from(MemoryCacheConfig prototype) {
            this.enabled(prototype.enabled());
            this.capacity(prototype.capacity());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            this.capacity(builder.capacity());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("capacity").as(Size.class).ifPresent(this::capacity);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER capacity(Size capacity) {
            Objects.requireNonNull(capacity);
            this.capacity = capacity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Size capacity() {
            return this.capacity;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "MemoryCacheConfigBuilder{enabled=" + this.enabled + ",capacity=" + String.valueOf(this.capacity) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class MemoryCacheConfigImpl
        implements MemoryCacheConfig,
        Supplier<MemoryCache> {
            private final boolean enabled;
            private final Size capacity;

            protected MemoryCacheConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.capacity = builder.capacity();
            }

            public MemoryCache build() {
                return MemoryCache.create(this);
            }

            @Override
            public MemoryCache get() {
                return this.build();
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public Size capacity() {
                return this.capacity;
            }

            public String toString() {
                return "MemoryCacheConfig{enabled=" + this.enabled + ",capacity=" + String.valueOf(this.capacity) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MemoryCacheConfig)) {
                    return false;
                }
                MemoryCacheConfig other = (MemoryCacheConfig)o;
                return this.enabled == other.enabled() && Objects.equals(this.capacity, other.capacity());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.capacity);
            }
        }
    }
}

