/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.Main;
import io.helidon.spi.HelidonShutdownHandler;
import io.helidon.webserver.staticcontent.IoSupplier;
import io.helidon.webserver.staticcontent.TemporaryStorage;
import io.helidon.webserver.staticcontent.TemporaryStorageConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class TemporaryStorageImpl
implements TemporaryStorage {
    private static final System.Logger LOGGER = System.getLogger(TemporaryStorage.class.getName());
    private final TemporaryStorageConfig config;
    private final Supplier<Optional<Path>> tmpFile;

    TemporaryStorageImpl(TemporaryStorageConfig config) {
        this.config = config;
        this.tmpFile = TemporaryStorageImpl.tempFileSupplier(config);
    }

    public TemporaryStorageConfig prototype() {
        return this.config;
    }

    @Override
    public Optional<Path> createFile() {
        return this.tmpFile.get();
    }

    private static Supplier<Optional<Path>> tempFileSupplier(TemporaryStorageConfig config) {
        Optional<Path> configuredDir;
        if (!config.enabled()) {
            return Optional::empty;
        }
        DeleteFilesHandler deleteFilesHandler = new DeleteFilesHandler();
        if (config.deleteOnExit()) {
            Main.addShutdownHandler((HelidonShutdownHandler)deleteFilesHandler);
        }
        IoSupplier<Path> pathSupplier = (configuredDir = config.directory()).isPresent() ? () -> Files.createTempFile((Path)configuredDir.get(), config.filePrefix(), config.fileSuffix(), new FileAttribute[0]) : () -> Files.createTempFile(config.filePrefix(), config.fileSuffix(), new FileAttribute[0]);
        return () -> {
            deleteFilesHandler.tempFilesLock.lock();
            try {
                if (deleteFilesHandler.closed) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Path path = (Path)pathSupplier.get();
                deleteFilesHandler.tempFiles.add(path);
                Optional<Path> optional = Optional.of(path);
                return optional;
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.WARNING, "Failed to create temporary file. Config: " + String.valueOf(config), (Throwable)e);
                Optional optional = Optional.empty();
                return optional;
            }
            finally {
                deleteFilesHandler.tempFilesLock.unlock();
            }
        };
    }

    private static class DeleteFilesHandler
    implements HelidonShutdownHandler {
        private final List<Path> tempFiles = new ArrayList<Path>();
        private final ReentrantLock tempFilesLock = new ReentrantLock();
        private volatile boolean closed;

        private DeleteFilesHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.tempFilesLock.lock();
            try {
                this.closed = true;
                for (Path tempFile : this.tempFiles) {
                    try {
                        Files.deleteIfExists(tempFile);
                    }
                    catch (IOException e) {
                        LOGGER.log(System.Logger.Level.WARNING, "Failed to delete temporary file: " + String.valueOf(tempFile.toAbsolutePath()), (Throwable)e);
                    }
                }
                this.tempFiles.clear();
            }
            finally {
                this.tempFilesLock.unlock();
            }
        }
    }
}

